/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import projections.analysis.RangeHistory;
import projections.gui.Analysis;
import projections.gui.JSelectField;
import projections.gui.JTimeTextField;
import projections.gui.OrderedIntList;
import projections.gui.ProjectionsWindow;
import projections.gui.U;
import projections.gui.Util;

public class RangeDialog
extends JDialog
implements ActionListener,
KeyListener,
FocusListener {
    private static final int DIALOG_OK = 0;
    private static final int DIALOG_CANCELLED = 1;
    ProjectionsWindow parentWindow;
    JPanel mainPanel;
    JPanel historyPanel;
    JPanel buttonPanel;
    JSelectField processorsField;
    JTimeTextField startTimeField;
    JTimeTextField endTimeField;
    JPanel timePanel;
    JPanel processorsPanel;
    JButton bOK;
    JButton bUpdate;
    JButton bCancel;
    JComboBox historyList;
    JButton bAddToHistory;
    JButton bSaveHistory;
    private JLabel startTextLabel;
    private JLabel endTextLabel;
    private JLabel totalTimeTextLabel;
    private JLabel processorTextLabel;
    private JLabel totalTimeLabel;
    private JLabel validTimeRangeLabel;
    private JLabel validProcessorsLabel;
    protected long totalTime;
    protected long totalValidTime;
    protected int numProcessors;
    protected OrderedIntList validProcessors = new OrderedIntList();
    protected long startTime = -1L;
    protected long endTime = -1L;
    RangeHistory history;
    Vector historyVector;
    Vector historyStringVector;
    private boolean layoutComplete = false;
    private int dialogState;

    public RangeDialog(ProjectionsWindow projectionsWindow, String string) {
        super(projectionsWindow, string, true);
        this.parentWindow = projectionsWindow;
        this.numProcessors = Analysis.getNumProcessors();
        this.totalValidTime = this.totalTime = Analysis.getTotalTime();
        this.history = new RangeHistory();
        try {
            this.historyVector = this.history.loadRanges();
            this.historyStringVector = new Vector();
            int n = 0;
            while (n < this.historyVector.size() / 2) {
                String string2 = U.t((Long)this.historyVector.elementAt(n * 2)) + " to " + U.t((Long)this.historyVector.elementAt(n * 2 + 1));
                this.historyStringVector.add(string2);
                ++n;
            }
        }
        catch (IOException iOException) {
            System.err.println("Error: " + iOException.toString());
        }
        this.setModal(true);
        this.dialogState = 1;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.bOK) {
                JTextField jTextField = this.checkConsistent();
                if (jTextField != null) {
                    jTextField.selectAll();
                    jTextField.requestFocus();
                    return;
                }
                this.dialogState = 0;
                this.setVisible(false);
            } else {
                if (jButton == this.bUpdate) {
                    this.updateData(this.processorsField);
                    this.updateData(this.startTimeField);
                    this.updateData(this.endTimeField);
                    return;
                }
                if (jButton == this.bCancel) {
                    this.dialogState = 1;
                    this.setVisible(false);
                } else if (jButton == this.bAddToHistory) {
                    long l = this.startTimeField.getValue();
                    long l2 = this.endTimeField.getValue();
                    this.history.add(l, l2);
                    String string = U.t(l) + " to " + U.t(l2);
                    this.historyList.insertItemAt(string, 0);
                    this.historyList.setSelectedIndex(0);
                } else if (jButton == this.bSaveHistory) {
                    try {
                        this.history.save();
                    }
                    catch (IOException iOException) {
                        System.err.println("Save Error: " + iOException.toString());
                    }
                }
            }
        } else if (actionEvent.getSource() instanceof JTextField) {
            this.updateData((JTextField)actionEvent.getSource());
            this.bOK.setEnabled(true);
        } else if (actionEvent.getSource() instanceof JComboBox) {
            int n = this.historyList.getSelectedIndex();
            if (n == -1) {
                return;
            }
            this.startTimeField.setValue((Long)this.historyVector.elementAt(n * 2));
            this.endTimeField.setValue((Long)this.historyVector.elementAt(n * 2 + 1));
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getComponent() instanceof JTextField) {
            this.updateData((JTextField)focusEvent.getComponent());
            this.bOK.setEnabled(true);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (keyEvent.getComponent() instanceof JTextField) {
            JTextField jTextField = (JTextField)keyEvent.getComponent();
            switch (n) {
                case 10: {
                    this.updateData(jTextField);
                    this.bOK.setEnabled(true);
                    break;
                }
                case 9: {
                    this.updateData(jTextField);
                    this.bOK.setEnabled(true);
                    break;
                }
                default: {
                    this.bOK.setEnabled(false);
                }
            }
        }
    }

    public void displayDialog() {
        if (!this.layoutComplete) {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    RangeDialog.this.dialogState = 1;
                    RangeDialog.this.setVisible(false);
                }
            });
            this.mainPanel = this.createMainLayout();
            this.historyPanel = this.createHistoryLayout();
            this.buttonPanel = this.createButtonLayout();
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.mainPanel, "North");
            this.getContentPane().add((Component)this.historyPanel, "Center");
            this.getContentPane().add((Component)this.buttonPanel, "South");
            this.layoutComplete = true;
            this.pack();
            this.setResizable(false);
        } else {
            this.preserveState();
        }
        this.setVisible(true);
    }

    JPanel createMainLayout() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.processorsPanel = new JPanel();
        this.processorsPanel.setLayout(gridBagLayout);
        this.validProcessorsLabel = new JLabel("Valid Processors = " + Analysis.getValidProcessorString(), 2);
        this.processorTextLabel = new JLabel("Processors :", 2);
        this.processorsField = new JSelectField(Analysis.getValidProcessorString(), 12);
        this.processorsField.addActionListener(this);
        Util.gblAdd(this.processorsPanel, this.validProcessorsLabel, gridBagConstraints, 0, 0, 2, 1, 1, 1);
        Util.gblAdd(this.processorsPanel, this.processorTextLabel, gridBagConstraints, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.processorsPanel, this.processorsField, gridBagConstraints, 1, 1, 1, 1, 1, 1);
        this.timePanel = new JPanel();
        this.timePanel.setLayout(gridBagLayout);
        this.validTimeRangeLabel = new JLabel("Valid Time Range = " + U.t(0L) + " to " + U.t(Analysis.getTotalTime()), 2);
        this.startTextLabel = new JLabel("Start Time :", 2);
        this.startTimeField = new JTimeTextField(0L, 12);
        this.endTextLabel = new JLabel("End Time :", 2);
        this.endTimeField = new JTimeTextField(Analysis.getTotalTime(), 12);
        this.totalTimeTextLabel = new JLabel("Total Time selected :", 2);
        this.totalTimeLabel = new JLabel(U.t(Analysis.getTotalTime()), 2);
        this.startTimeField.addActionListener(this);
        this.endTimeField.addActionListener(this);
        this.startTimeField.addKeyListener(this);
        this.endTimeField.addKeyListener(this);
        this.startTimeField.addFocusListener(this);
        this.endTimeField.addFocusListener(this);
        Util.gblAdd(this.timePanel, this.validTimeRangeLabel, gridBagConstraints, 0, 0, 4, 1, 1, 1);
        Util.gblAdd(this.timePanel, this.startTextLabel, gridBagConstraints, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.timePanel, this.startTimeField, gridBagConstraints, 1, 1, 1, 1, 1, 1);
        Util.gblAdd(this.timePanel, this.endTextLabel, gridBagConstraints, 2, 1, 1, 1, 1, 1);
        Util.gblAdd(this.timePanel, this.endTimeField, gridBagConstraints, 3, 1, 1, 1, 1, 1);
        Util.gblAdd(this.timePanel, this.totalTimeTextLabel, gridBagConstraints, 0, 2, 1, 1, 1, 1);
        Util.gblAdd(this.timePanel, this.totalTimeLabel, gridBagConstraints, 1, 2, 3, 1, 1, 1);
        jPanel.setLayout(gridBagLayout);
        Util.gblAdd(jPanel, this.processorsPanel, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(jPanel, this.timePanel, gridBagConstraints, 0, 1, 1, 1, 1, 1);
        return jPanel;
    }

    JPanel createButtonLayout() {
        JPanel jPanel = new JPanel();
        this.bOK = new JButton("OK");
        this.bUpdate = new JButton("Update");
        this.bCancel = new JButton("Cancel");
        jPanel.add(this.bOK);
        jPanel.add(this.bUpdate);
        jPanel.add(this.bCancel);
        this.bOK.addActionListener(this);
        this.bUpdate.addActionListener(this);
        this.bCancel.addActionListener(this);
        return jPanel;
    }

    private JPanel createHistoryLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.historyList = new JComboBox(this.historyStringVector);
        this.historyList.setEditable(false);
        this.historyList.setMaximumRowCount(5);
        if (this.historyList.getItemCount() > 0) {
            this.historyList.setSelectedIndex(0);
        }
        this.bAddToHistory = new JButton("Add to History List");
        this.bSaveHistory = new JButton("Save History to Disk");
        this.historyList.addActionListener(this);
        this.bAddToHistory.addActionListener(this);
        this.bSaveHistory.addActionListener(this);
        Util.gblAdd(jPanel, this.historyList, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(jPanel, this.bAddToHistory, gridBagConstraints, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(jPanel, this.bSaveHistory, gridBagConstraints, 1, 1, 1, 1, 1, 1);
        return jPanel;
    }

    void updateData(JTextField jTextField) {
        if (jTextField instanceof JTimeTextField) {
            if (jTextField == this.startTimeField || jTextField == this.endTimeField) {
                this.totalTime = this.endTimeField.getValue() - this.startTimeField.getValue();
                this.totalTimeLabel.setText(U.t(this.totalTime));
            }
        } else if (!(jTextField instanceof JSelectField) || jTextField == this.processorsField) {
            // empty if block
        }
    }

    void preserveState() {
        this.startTime = this.startTimeField.getValue();
        this.endTime = this.endTimeField.getValue();
        this.validProcessors = this.getValidProcessors();
    }

    JTextField checkConsistent() {
        if (this.startTimeField.getValue() >= this.endTimeField.getValue()) {
            return this.startTimeField;
        }
        if (this.startTimeField.getValue() < 0L) {
            return this.startTimeField;
        }
        if (this.endTimeField.getValue() > this.totalValidTime) {
            return this.endTimeField;
        }
        return null;
    }

    public boolean isCancelled() {
        return this.dialogState == 1;
    }

    public boolean isModified() {
        return this.startTime != this.startTimeField.getValue() || this.endTime != this.endTimeField.getValue() || !this.validProcessors.equals(this.getValidProcessors());
    }

    public long getStartTime() {
        return this.startTimeField.getValue();
    }

    public void setStartTime(long l) {
        this.startTimeField.setValue(l);
    }

    public long getEndTime() {
        return this.endTimeField.getValue();
    }

    public void setEndTime(long l) {
        this.endTimeField.setValue(l);
    }

    public OrderedIntList getValidProcessors() {
        return this.processorsField.getValue(this.numProcessors);
    }

    public String getValidProcessorString() {
        return this.processorsField.getText();
    }

    public void setValidProcessors(OrderedIntList orderedIntList) {
        this.processorsField.setText(orderedIntList.listToString());
    }

    public void setValidProcessors(String string) {
        this.processorsField.setText(string);
    }
}

