recursive subroutine MPI_Main
  implicit none
  include 'mpif.h'

  integer :: myrank, size, ierr, left, right, step, i
  double precision :: a, b
  integer, dimension(MPI_STATUS_SIZE) :: sts

  step = 0
  a = 0.1
  b = 0.3

  call MPI_Init(ierr)
  call MPI_Comm_rank(MPI_COMM_WORLD, myrank, ierr)
  call MPI_Comm_size(MPI_COMM_WORLD, size, ierr)

  left = mod((myrank+size-1), size)
  right = mod((myrank+1), size)

  do step = 0, 6
    call MPI_Send(a, 1, MPI_DOUBLE_PRECISION, right, 0, MPI_COMM_WORLD, ierr)
    call MPI_Recv(b, 1, MPI_DOUBLE_PRECISION, left, 0, MPI_COMM_WORLD, sts, ierr)
    write(*,*) '[',myrank,']step',step,', a=',a,', b=',b
    if(step .eq. 2) then
      call MPI_Checkpoint('log');
    end if
  end do

  call MPI_Finalize(ierr)

end subroutine
