/*****************************************************************************
 * $Source: /cvsroot/charm-5.8/src/ck-ldb/BaseLB.C,v $
 * $Author: gzheng $
 * $Date: 2003/12/17 15:50:24 $
 * $Revision: 1.24 $
 *****************************************************************************/

/**
 * \addtogroup CkLdb
*/
/*@{*/

#include <charm++.h>
#include <BaseLB.h>

#if CMK_LBDB_ON

void BaseLB::initLB(const CkLBOptions &opt) {
  seqno = opt.getSeqNo();
  CkpvAccess(numLoadBalancers) ++;
/*
  if (CkpvAccess(numLoadBalancers) - CkpvAccess(hasNullLB) > 1)
    CmiAbort("Error: try to create more than one load balancer strategies!");
*/
  theLbdb = CProxy_LBDatabase(_lbdb).ckLocalBranch();
  lbname = "Unknown";
  // register this load balancer to LBDatabase at the sequence number
  theLbdb->addLoadbalancer(this, seqno);
}

BaseLB::~BaseLB() {
  CkpvAccess(numLoadBalancers) --;
}

void BaseLB::unregister() {
  theLbdb->RemoveLocalBarrierReceiver(receiver);
  CkpvAccess(numLoadBalancers) --;
}

void BaseLB::pup(PUP::er &p) { 
  IrrGroup::pup(p); 
  p|seqno;
  if (p.isUnpacking())
  {
    if (CkMyPe()==0) {
      if (seqno!=-1) {
        int newseq = LBDatabaseObj()->getLoadbalancerTicket();
        CmiAssert(newseq == seqno);
      }
    }
    initLB(seqno);
  }
}

#else
BaseLB::~BaseLB() {} 
void BaseLB::initLB(const CkLBOptions &) {}
void BaseLB::unregister() {}
void BaseLB::pup(PUP::er &p) {}
#endif

#include "BaseLB.def.h"

/*@}*/
