#include <math.h>
#include "app.decl.h"
#include "liveViz.h"

CkArrayID a;

class app: public Chare {
public:
  app(CkArgMsg *m) {
    int nElements=10;
    if (m->argc>1) nElements=atoi(m->argv[1]);
    CProxy_app thisproxy(thishandle);
    a = CProxy_appArray::ckNew(nElements);
    CkCallback c(CkIndex_appArray::requestNextFrame(0),a);
    liveVizConfig cfg(false,false);
    cfg.moreVerbose(); cfg.moreVerbose();
    liveVizInit(cfg,a,c);
  }
};

class appArray: public ArrayElement1D {
public: 
  appArray(CkMigrateMessage * m) {};
  appArray() {}

  void requestNextFrame(liveVizRequestMsg *m) {
    int x=-3+6*thisIndex,y=32; // Topleft corner of my part of the image
    int w=8,h=32; // Size of my part of the image
    unsigned char *intensity=new unsigned char[w*h];
    for (int i=0; i<w*h; i++) intensity[i] = (byte) 64;//15;
    liveVizDeposit(m, x,y, w,h, intensity, this);
    delete[] intensity;
  }
};

#include "app.def.h"

