/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import projections.gui.Analysis;
import projections.gui.ColorSelectable;
import projections.gui.EntrySelectionDialog;
import projections.gui.GenericGraphWindow;
import projections.gui.IntervalRangeDialog;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.SwingWorker;
import projections.gui.U;
import projections.gui.Util;

public class GeneralGraphWindow
extends GenericGraphWindow
implements ActionListener,
ColorSelectable {
    private GeneralGraphWindow thisWindow;
    private EntrySelectionDialog entryDialog;
    private JPanel mainPanel;
    private JPanel controlPanel;
    private JButton epSelection;
    private JButton setRanges;
    int startInterval;
    int endInterval;
    long intervalSize;
    OrderedIntList processorList;
    private int numEPs;
    private String[] typeLabelNames = new String[]{"Entry Points"};
    private boolean[][] stateArray;
    private boolean[][] existsArray;
    private Color[][] colorArray;
    private String[] entryNames;
    private double[][] graphData;
    private double[][] outputData;
    private Color[] outColors;

    public GeneralGraphWindow(MainWindow mainWindow, Integer n) {
        super("General Graph Tools", mainWindow, n);
        this.setGraphSpecificData();
        this.numEPs = Analysis.getNumUserEntries();
        this.stateArray = new boolean[1][this.numEPs];
        this.existsArray = new boolean[1][this.numEPs];
        this.colorArray = new Color[1][this.numEPs];
        this.entryNames = new String[this.numEPs];
        int n2 = 0;
        while (n2 < this.numEPs) {
            this.colorArray[0][n2] = Analysis.getEntryColor(n2);
            this.entryNames[n2] = Analysis.getEntryName(n2);
            ++n2;
        }
        this.mainPanel = new JPanel();
        this.getContentPane().add(this.mainPanel);
        this.createLayout();
        this.pack();
        this.thisWindow = this;
        this.showDialog();
    }

    private void createLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        this.mainPanel.setLayout(gridBagLayout);
        this.epSelection = new JButton("Select Entry Points");
        this.epSelection.addActionListener(this);
        this.setRanges = new JButton("Select New Range");
        this.setRanges.addActionListener(this);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(gridBagLayout);
        Util.gblAdd(this.controlPanel, this.epSelection, gridBagConstraints, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(this.controlPanel, this.setRanges, gridBagConstraints, 1, 0, 1, 1, 0, 0);
        JPanel jPanel = this.getMainPanel();
        Util.gblAdd(this.mainPanel, jPanel, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.controlPanel, gridBagConstraints, 0, 1, 1, 0, 0, 0);
    }

    public void setGraphSpecificData() {
        this.setXAxis("Time in us", "");
        this.setYAxis("Entry point execution time", "us");
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new IntervalRangeDialog(this, "Select Range");
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    if (GeneralGraphWindow.this.dialog.isModified()) {
                        Analysis.LoadGraphData(GeneralGraphWindow.this.intervalSize, GeneralGraphWindow.this.startInterval, GeneralGraphWindow.this.endInterval, true, GeneralGraphWindow.this.processorList);
                        GeneralGraphWindow.this.fillGraphData();
                    }
                    return null;
                }

                public void finished() {
                    GeneralGraphWindow.this.setOutputGraphData();
                    GeneralGraphWindow.this.thisWindow.setVisible(true);
                }
            };
            swingWorker.start();
        }
    }

    public void getDialogData() {
        IntervalRangeDialog intervalRangeDialog = (IntervalRangeDialog)this.dialog;
        this.intervalSize = intervalRangeDialog.getIntervalSize();
        this.startInterval = (int)intervalRangeDialog.getStartInterval();
        this.endInterval = (int)intervalRangeDialog.getEndInterval();
        this.processorList = intervalRangeDialog.getValidProcessors();
    }

    public void showWindow() {
    }

    private void fillGraphData() {
        int n = this.endInterval - this.startInterval + 1;
        this.graphData = new double[n][this.numEPs];
        int n2 = 0;
        while (n2 < this.numEPs) {
            int n3;
            int[][] nArray = Analysis.getUserEntryData(n2, 2);
            int n4 = 0;
            while (n4 < nArray.length) {
                n3 = 0;
                while (n3 < n) {
                    double[] dArray = this.graphData[n3];
                    int n5 = n2;
                    dArray[n5] = dArray[n5] + (double)nArray[n4][n3];
                    ++n3;
                }
                ++n4;
            }
            n3 = 0;
            while (n3 < n) {
                if (this.graphData[n3][n2] > 0.0) {
                    this.existsArray[0][n2] = true;
                    this.stateArray[0][n2] = true;
                    break;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void applyDialogColors() {
        this.setOutputGraphData();
    }

    private void setOutputGraphData() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.numEPs) {
            if (this.stateArray[0][n2]) {
                ++n;
            }
            ++n2;
        }
        if (n != 0) {
            int n3 = this.endInterval - this.startInterval + 1;
            this.outputData = new double[n3][n];
            this.outColors = new Color[n];
            int n4 = 0;
            while (n4 < n3) {
                int n5 = 0;
                int n6 = 0;
                while (n6 < this.numEPs) {
                    if (this.stateArray[0][n6]) {
                        this.outputData[n4][n5] = this.graphData[n4][n6];
                        this.outColors[n5++] = this.colorArray[0][n6];
                    }
                    ++n6;
                }
                ++n4;
            }
            this.setXAxis("Time Interval (" + U.t(this.intervalSize) + ")", "", this.startInterval, 1.0);
            this.setYAxis("Entry point execution time", "us");
            this.setDataSource("General Graph", this.outputData, this.outColors, this.thisWindow);
            super.refreshGraph();
        }
    }

    public String[] getPopup(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return null;
        }
        int n3 = 0;
        String string = "";
        int n4 = 0;
        while (n4 < this.numEPs) {
            if (this.stateArray[0][n4] && n3++ == n2) {
                string = Analysis.getEntryName(n4);
                break;
            }
            ++n4;
        }
        String[] stringArray = new String[]{"Entry Method: " + string, "Execution Time = " + U.t((long)this.outputData[n][n2])};
        return stringArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.epSelection) {
                if (this.entryDialog == null) {
                    this.entryDialog = new EntrySelectionDialog(this, this, this.typeLabelNames, this.stateArray, this.colorArray, this.existsArray, this.entryNames);
                }
                this.entryDialog.showDialog();
            } else if (jButton == this.setRanges) {
                this.showDialog();
            }
        }
    }
}

