#include <ampi.h>
#include <charm++.h>

int 
main(int argc, char** argv)
{
  int i, size, rank;
  int *winArea, *putvals;
  MPI_Win win;

  MPI_Init(&argc, &argv);
  MPI_Comm_size(MPI_COMM_WORLD, &size);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);

  MPI_Alloc_mem(sizeof(int) * size, MPI_INFO_NULL, &winArea);
  MPI_Alloc_mem(sizeof(int) * size, MPI_INFO_NULL, &putvals);
  MPI_Win_create((void*)winArea, sizeof(int) * size, sizeof(int),  MPI_INFO_NULL,
		 MPI_COMM_WORLD, &win);
  
  for (i = 0; i < size; ++i) {
    winArea[i] = -1;
    putvals[i] = rank;
  }

  MPI_Win_fence(0, win);
  
  for (i = 0; i < size; i++){
    MPI_Put(&putvals[i], 1, MPI_INT, i, rank, 1, MPI_INT, win);
  }

  MPI_Win_fence(0, win);

  CkPrintf("rank[%d] get value: [",rank);  
  for (i = 0; i < size; ++i){
      CkPrintf(" %d ",winArea[i]);
  }
  CkPrintf("]\n");

  MPI_Win_free(&win);  
  MPI_Free_mem(winArea);
  MPI_Free_mem(putvals);
  MPI_Finalize();
  return(0);
}
