#include "pose.h"
#include "pgm.h"
#include "Pgm.def.h"
#include "TCsim_sim.h"
#include "NetSim_sim.h"
#include <unistd.h>

int netsim_on = 1;

main::main(CkArgMsg *m)
{ 
  CkGetChareID(&mainhandle);
  CProxy_main M(mainhandle);

  if (CmiGetArgFlag(m->argv, "+netsimoff")) {
    netsim_on = 0;
  }

  if(CmiGetArgc(m->argv)<5)
    CmiAbort("Usage: pgm application bandwidth wrapcost maxpacketsize\n");

  int arg = 1;
  const char *app = m->argv[arg++];
  for (int i=0; i<strlen(app)+1; i++) appname[i] = app[i];
  bandwidth = atol(m->argv[arg++]);
  wrapcost = atol(m->argv[arg++]);
  maxPktSize = atol(m->argv[arg++]);
  CmiAssert(bandwidth>0 && wrapcost>0 && maxPktSize>0);
  int totalBGProcs, numX, numY, numZ, numCth, numPes;

  //read in parameters/data files
  BgLoadTraceSummary("bgTrace", totalBGProcs, numX, numY, numZ, numCth, numWth, numPes);

  CkPrintf("bgtrace: totalBGProcs=%d X=%d Y=%d Z=%d #Cth=%d #Wth=%d #Pes=%d\n",
	   totalBGProcs, numX, numY, numZ, numCth, numWth, numPes);
  // need to read in a configuration for NetSim
  netLength = numX;
  netHeight = numY;
  netWidth = numZ;
  CkPrintf("Net config: %d x %d x %d  Bandwidth=%ld Wrapcost=%ld PktSz=%ld\n",
	   netLength, netHeight, netWidth,bandwidth, wrapcost, maxPktSize);
  CkPrintf("Opts: netsim on: %d\n", netsim_on);
  // make routeMap
//  Label Distlabel(netLength*netHeight*netWidth+baseval,0);

  int baseval=totalBGProcs + numX*numY*numZ;
  int idstart=baseval;

  POSE_init();
  //POSE_useET(16559494);
  POSE_useID();
  // build network of nodes
  CkGroupID groupID = CProxy_routeMap::ckNew(netLength, netHeight, netWidth,
					     idstart, wrapcost);
  CProxy_routeMap nodemap_proxy(groupID);
  routeMap *nodemap = nodemap_proxy.ckLocalBranch();
  int ***pecoords = (int***)malloc(netLength*sizeof(int**));
  for (int z=0; z<netLength; z++)
    pecoords[z] = (int**)malloc(netHeight*sizeof(int*));
  for (int x=0; x<netLength; x++)
    for (int y=0; y<netHeight; y++)
      pecoords[x][y] = (int*)malloc(netWidth*sizeof(int));

  // need to properly weight l, then h, then w
  int base = netLength*netHeight*netWidth;
  int perPE = base/CkNumPes(), onPE = 0, count = 0;
  for (int l=0; l<netLength; l++)
    for (int h=0; h<netHeight; h++)
      for (int w=0; w<netWidth; w++) {
	pecoords[l][h][w] = onPE;
	count++;
	if (count == perPE) {
	  onPE++; 
	  if (onPE == CkNumPes()) 
	    onPE = 0;
	  count = 0;
	}
      }

  // now that we have the nodemap we can make the nodes
  int node=0, l, h, w;
  for (l=0; l<netLength; l++)
    for (h=0; h<netHeight; h++)
      for (w=0; w<netWidth; w++) {
	Label newlabel(idstart+node++,0);
	tridcoord position(newlabel.idAsInt(),l,h,w);
	SwitchInit *newnode = new SwitchInit(newlabel, netLength, netHeight,
					     netWidth, idstart, position,
					     wrapcost, bandwidth, groupID);
	newnode->Timestamp(0);
	/*
	CkPrintf("Creating Switch %d on PE %d\n", newnode->id.idAsInt(), 
		 pecoords[l][h][w]);
	*/
	(*(CProxy_Switch *) &POSE_Objects)[newnode->id.idAsInt()].insert(newnode,pecoords[l][h][w]);
      }

  // create BGprocs
  int BGnodes = netLength*netWidth*netHeight, dest, n=0;
  BGprocMsg *bgm;
  for (l=0; l<netLength; l++)
    for (h=0; h<netHeight; h++)
      for (w=0; w<netWidth; w++) {
        int switchIdx = n + idstart;
        BGnodeMsg *nodem = new BGnodeMsg(n, numWth, switchIdx);
	nodem->Timestamp(0);
	/*
	CkPrintf("Creating BGnode %d \n", n+BGnodes);
	*/
	(*(CProxy_BGnode *) &POSE_Objects)[n+BGnodes].insert(nodem);
	for (int i=0; i<numWth; i++) {
	  bgm = new BGprocMsg(n+BGnodes);
	  bgm->Timestamp(0);
	  dest = pecoords[l][h][w];
	  /*
	  CkPrintf("Creating BGproc %d on PE %d\n", n, dest);
	  */
	  (*(CProxy_BGproc *) &POSE_Objects)[n].insert(bgm, dest);
	  n++;
	}
      }
  POSE_start();
}
