/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import projections.analysis.GenericLogReader;
import projections.gui.Analysis;
import projections.gui.GenericGraphWindow;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.RangeDialog;
import projections.gui.SwingWorker;
import projections.gui.Util;
import projections.misc.LogEntryData;

public class CommWindow
extends GenericGraphWindow
implements ItemListener {
    private double[][] msgCount;
    private double[][] byteCount;
    private double[][] recivedMsgCount;
    private double[][] exclusiveSent;
    private ArrayList histogram;
    private int[] histArray;
    private String currentArrayName;
    private String[][] popupText;
    private String[][] EPNames;
    private JPanel mainPanel;
    private JPanel graphPanel;
    private JPanel checkBoxPanel;
    private Checkbox sentMssgs;
    private Checkbox sentBytes;
    private Checkbox histogramCB;
    private Checkbox recivedMssgs;
    private Checkbox sentExclusive;
    private CommWindow thisWindow;

    public CommWindow(MainWindow mainWindow, Integer n) {
        super("Projections Communications", mainWindow, n);
        this.setGraphSpecificData();
        this.mainPanel = new JPanel();
        this.getContentPane().add(this.mainPanel);
        this.createLayout();
        this.setPopupText("histArray");
        this.pack();
        this.thisWindow = this;
        this.showDialog();
    }

    public void repaint() {
        super.refreshGraph();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof Checkbox) {
            this.setCursor(new Cursor(3));
            Checkbox checkbox = (Checkbox)itemEvent.getSource();
            if (checkbox == this.histogramCB) {
                this.setDataSource("Histogram", this.histArray, (GenericGraphWindow)this);
                this.setPopupText("histArray");
                this.setYAxis("Frequency", null);
                this.setXAxis("Byte Size", "bytes");
                super.refreshGraph();
            } else if (checkbox == this.sentMssgs) {
                this.setDataSource("Communications", this.msgCount, (GenericGraphWindow)this);
                this.setPopupText("msgCount");
                this.setYAxis("Messages Sent", "");
                this.setXAxis("Processor", "");
                super.refreshGraph();
            } else if (checkbox == this.sentBytes) {
                this.setDataSource("Communications", this.byteCount, (GenericGraphWindow)this);
                this.setPopupText("byteCount");
                this.setYAxis("Bytes Sent", "bytes");
                this.setXAxis("Processor", "");
                super.refreshGraph();
            } else if (checkbox == this.recivedMssgs) {
                this.setDataSource("Communications", this.recivedMsgCount, (GenericGraphWindow)this);
                this.setPopupText("recivedMsgCount");
                this.setYAxis("Mssages Recived", "");
                this.setXAxis("Processor", "");
                super.refreshGraph();
            } else if (checkbox == this.sentExclusive) {
                this.setDataSource("Communications", this.exclusiveSent, (GenericGraphWindow)this);
                this.setPopupText("exclusiveSent");
                this.setYAxis("Messages Sent Externally", "");
                this.setXAxis("Processor", "");
                super.refreshGraph();
            }
            this.setCursor(new Cursor(0));
        }
    }

    private void setPopupText(String string) {
        this.currentArrayName = string;
    }

    public String[] getPopup(int n, int n2) {
        if (n < 0 || n2 < 0 || this.currentArrayName == null) {
            return null;
        }
        if (this.EPNames == null) {
            this.EPNames = Analysis.getEntryNames();
        }
        String[] stringArray = new String[2];
        if (this.currentArrayName.equals("histArray")) {
            stringArray[0] = n + " bytes";
            stringArray[1] = "Count = " + this.histArray[n];
        } else if (this.currentArrayName.equals("msgCount")) {
            stringArray[0] = "EPid: " + this.EPNames[n2][0];
            stringArray[1] = "Count = " + this.msgCount[n][n2];
        } else if (this.currentArrayName.equals("byteCount")) {
            stringArray[0] = "EPid: " + this.EPNames[n2][0];
            stringArray[1] = "Bytes = " + this.byteCount[n][n2];
        } else if (this.currentArrayName.equals("recivedMsgCount")) {
            stringArray[0] = "EPid: " + this.EPNames[n2][0];
            stringArray[1] = "Count = " + this.recivedMsgCount[n][n2];
        } else if (this.currentArrayName.equals("exclusiveSent")) {
            stringArray[0] = "EPid: " + this.EPNames[n2][0];
            stringArray[1] = "Count = " + this.exclusiveSent[n][n2];
        }
        return stringArray;
    }

    protected void createLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        this.mainPanel.setLayout(gridBagLayout);
        this.graphPanel = this.getMainPanel();
        this.checkBoxPanel = new JPanel();
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.histogramCB = new Checkbox("Histogram", checkboxGroup, true);
        this.sentMssgs = new Checkbox("Messages Sent (mssgs)", checkboxGroup, false);
        this.sentBytes = new Checkbox("Messages Sent (bytes)", checkboxGroup, false);
        this.recivedMssgs = new Checkbox("Messages Recived", checkboxGroup, false);
        this.sentExclusive = new Checkbox("Messages Sent Externally", checkboxGroup, false);
        this.histogramCB.addItemListener(this);
        this.sentMssgs.addItemListener(this);
        this.sentBytes.addItemListener(this);
        this.recivedMssgs.addItemListener(this);
        this.sentExclusive.addItemListener(this);
        Util.gblAdd(this.checkBoxPanel, this.histogramCB, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.sentMssgs, gridBagConstraints, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.sentBytes, gridBagConstraints, 2, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.recivedMssgs, gridBagConstraints, 3, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.sentExclusive, gridBagConstraints, 4, 0, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.graphPanel, gridBagConstraints, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.checkBoxPanel, gridBagConstraints, 0, 2, 1, 1, 0, 0);
    }

    protected void setGraphSpecificData() {
        this.setXAxis("Byte Size", "");
        this.setYAxis("Frequency", "");
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new RangeDialog(this, "select Range");
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    CommWindow.access$002(CommWindow.this, new double[CommWindow.this.validPEs.size()][]);
                    CommWindow.access$102(CommWindow.this, new double[CommWindow.this.validPEs.size()][]);
                    CommWindow.access$202(CommWindow.this, new double[CommWindow.this.validPEs.size()][]);
                    CommWindow.access$302(CommWindow.this, new double[CommWindow.this.validPEs.size()][]);
                    CommWindow.this.getData();
                    return null;
                }

                public void finished() {
                    CommWindow.this.setDataSource("Histogram", CommWindow.this.histArray, (GenericGraphWindow)CommWindow.this.thisWindow);
                    CommWindow.this.thisWindow.setVisible(true);
                    CommWindow.this.thisWindow.repaint();
                }
            };
            swingWorker.start();
        }
    }

    public void showWindow() {
    }

    public void getDialogData() {
        super.getDialogData();
    }

    public void getData() {
        int n;
        LogEntryData logEntryData = new LogEntryData();
        OrderedIntList orderedIntList = this.validPEs.copyOf();
        int n2 = orderedIntList.size();
        int n3 = Analysis.getNumUserEntries();
        this.histogram = new ArrayList();
        int n4 = 0;
        ProgressMonitor progressMonitor = new ProgressMonitor(this, "Reading log files", "", 0, n2);
        while (orderedIntList.hasMoreElements()) {
            n = orderedIntList.nextElement();
            if (progressMonitor.isCanceled()) {
                progressMonitor.close();
                return;
            }
            progressMonitor.setNote("Reading data for PE " + n);
            progressMonitor.setProgress(n4 + 1);
            this.validate();
            GenericLogReader genericLogReader = new GenericLogReader(Analysis.getLogName(n), Analysis.getVersion());
            try {
                this.msgCount[n4] = new double[n3];
                this.byteCount[n4] = new double[n3];
                this.recivedMsgCount[n4] = new double[n3];
                this.exclusiveSent[n4] = new double[n3];
                genericLogReader.nextEventOnOrAfter(this.startTime, logEntryData);
                while (true) {
                    int n5;
                    genericLogReader.nextEvent(logEntryData);
                    if (logEntryData.type == 1) {
                        n5 = logEntryData.entry;
                        double[] dArray = this.msgCount[n4];
                        int n6 = n5;
                        dArray[n6] = dArray[n6] + 1.0;
                        double[] dArray2 = this.byteCount[n4];
                        int n7 = n5;
                        dArray2[n7] = dArray2[n7] + (double)logEntryData.msglen;
                        this.histogram.add(new Integer(logEntryData.msglen));
                        continue;
                    }
                    if (logEntryData.type != 2) continue;
                    n5 = logEntryData.entry;
                    double[] dArray = this.recivedMsgCount[n4];
                    int n8 = n5;
                    dArray[n8] = dArray[n8] + 1.0;
                    if (logEntryData.pe != n) continue;
                    double[] dArray3 = this.exclusiveSent[n4];
                    int n9 = n5;
                    dArray3[n9] = dArray3[n9] + 1.0;
                }
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {
                System.out.println("Exception: " + iOException);
                iOException.printStackTrace();
            }
            ++n4;
        }
        progressMonitor.close();
        n = (Integer)this.histogram.get(0);
        int n10 = (Integer)this.histogram.get(0);
        int n11 = 1;
        while (n11 < this.histogram.size()) {
            if ((Integer)this.histogram.get(n11) < n10) {
                n10 = (Integer)this.histogram.get(n11);
            }
            if ((Integer)this.histogram.get(n11) > n) {
                n = (Integer)this.histogram.get(n11);
            }
            ++n11;
        }
        this.histArray = new int[n + 1];
        int n12 = 0;
        while (n12 < Array.getLength(this.histArray)) {
            this.histArray[n12] = 0;
            ++n12;
        }
        int n13 = 0;
        while (n13 < this.histogram.size()) {
            int n14;
            int n15 = n14 = ((Integer)this.histogram.get(n13)).intValue();
            this.histArray[n15] = this.histArray[n15] + 1;
            ++n13;
        }
        int n16 = 0;
        while (n16 < n2) {
            int n17 = 0;
            while (n17 < n3) {
                this.exclusiveSent[n16][n17] = this.msgCount[n16][n17] - this.exclusiveSent[n16][n17];
                if (this.exclusiveSent[n16][n17] < 0.0) {
                    this.exclusiveSent[n16][n17] = 0.0;
                }
                ++n17;
            }
            ++n16;
        }
    }

    static /* synthetic */ double[][] access$002(CommWindow commWindow, double[][] dArray) {
        commWindow.msgCount = dArray;
        return dArray;
    }

    static /* synthetic */ double[][] access$102(CommWindow commWindow, double[][] dArray) {
        commWindow.byteCount = dArray;
        return dArray;
    }

    static /* synthetic */ double[][] access$202(CommWindow commWindow, double[][] dArray) {
        commWindow.recivedMsgCount = dArray;
        return dArray;
    }

    static /* synthetic */ double[][] access$302(CommWindow commWindow, double[][] dArray) {
        commWindow.exclusiveSent = dArray;
        return dArray;
    }
}

