/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileWriter;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import projections.gui.FormattedNumber;
import projections.gui.count.TableSorter;

public class EntryPointWindow
extends JFrame
implements ActionListener {
    private DefaultTableCellRenderer rightJustify_ = new DefaultTableCellRenderer();
    private TableSorter sorter = null;
    private JTable jTable = null;
    private EPTable epTable;
    private DecimalFormat format = null;
    private final JFileChooser fileChooser;
    private Color BACKGROUND = Color.black;
    private Color FOREGROUND = Color.white;
    private int currRow = 0;
    private int numRows = 100;
    private int numCols = 5;
    private RowData[] data = new RowData[this.numRows];
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$projections$gui$FormattedNumber;

    private void growTable() {
        this.numRows *= 2;
        RowData[] rowDataArray = new RowData[this.numRows];
        int n = 0;
        while (n < rowDataArray.length) {
            rowDataArray[n] = new RowData();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.data.length) {
            int n3 = 0;
            while (n3 < this.numCols) {
                rowDataArray[n2].value[n3] = this.data[n2].value[n3];
                rowDataArray[n2].color = this.data[n2].color;
                ++n3;
            }
            ++n2;
        }
        this.data = rowDataArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.fileChooser.showSaveDialog(this);
        try {
            if (n == 0) {
                this.fileChooser.approveSelection();
                FileWriter fileWriter = new FileWriter(this.fileChooser.getSelectedFile());
                int n2 = 0;
                while (n2 < this.currRow) {
                    int n3 = 0;
                    while (n3 < this.numCols) {
                        fileWriter.write(this.sorter.getValueAt(n2, n3).toString() + "\t");
                        ++n3;
                    }
                    fileWriter.write("\n");
                    ++n2;
                }
                fileWriter.close();
                JOptionPane.showMessageDialog(this, "File Saved", "Information", 1);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            JOptionPane.showMessageDialog(this, "Error While Saving File" + exception, "Error", 0);
        }
    }

    public EntryPointWindow() {
        super("Longest EntryPoints");
        if (this.format == null) {
            this.format = new DecimalFormat();
            this.format.setGroupingUsed(true);
        }
        JButton jButton = new JButton("Save");
        jButton.addActionListener(this);
        int n = 0;
        while (n < this.data.length) {
            this.data[n] = new RowData();
            ++n;
        }
        this.fileChooser = new JFileChooser();
        this.epTable = new EPTable();
        this.sorter = new TableSorter(this.epTable);
        this.jTable = new JTable(this.sorter);
        this.sorter.addMouseListenerToHeaderInTable(this.jTable);
        this.jTable.setColumnSelectionAllowed(false);
        this.jTable.setBackground(this.BACKGROUND);
        this.jTable.setForeground(this.FOREGROUND);
        TableColumn tableColumn = null;
        tableColumn = this.jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(5);
        tableColumn = this.jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(200);
        tableColumn.setCellRenderer(new NameRenderer());
        int n2 = 2;
        while (n2 < this.epTable.getColumnCount()) {
            tableColumn = this.jTable.getColumnModel().getColumn(n2);
            tableColumn.setPreferredWidth(75);
            tableColumn.setCellRenderer(this.rightJustify_);
            ++n2;
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(this.jTable), "Center");
        this.getContentPane().add((Component)jButton, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                EntryPointWindow.this.setVisible(false);
            }
        });
    }

    public void clearTableData() {
        this.data = new RowData[this.numRows];
        int n = 0;
        while (n < this.data.length) {
            this.data[n] = new RowData();
            ++n;
        }
        this.currRow = 0;
        this.sorter.tableChanged(new TableModelEvent(this.epTable, 0, this.epTable.getRowCount() - 1, -1));
    }

    public void writeToTable(int n, String string, long l, long l2, Color color) {
        if (this.currRow == this.numRows) {
            this.growTable();
        }
        this.data[this.currRow].value[0] = new Integer(n);
        this.data[this.currRow].value[1] = string;
        this.data[this.currRow].value[2] = new FormattedNumber(l, this.format);
        this.data[this.currRow].value[3] = new FormattedNumber(l2, this.format);
        this.data[this.currRow].value[4] = new FormattedNumber(l2 - l, this.format);
        this.data[this.currRow].color = color;
        ++this.currRow;
        this.sorter.tableChanged(new TableModelEvent(this.epTable, 0, this.epTable.getRowCount() - 1, -1));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class EPTable
    extends AbstractTableModel {
        public int getColumnCount() {
            return EntryPointWindow.this.numCols;
        }

        public int getRowCount() {
            if (EntryPointWindow.this.data != null) {
                return EntryPointWindow.this.data.length;
            }
            return 0;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Processor Number";
                }
                case 1: {
                    return "EntryPoint Name";
                }
                case 2: {
                    return "Begin Time";
                }
                case 3: {
                    return "End Time";
                }
                case 4: {
                    return "Delta Time";
                }
            }
            return "ERROR";
        }

        public Class getColumnClass(int n) {
            if (n == 1) {
                return class$java$lang$String == null ? (class$java$lang$String = EntryPointWindow.class$("java.lang.String")) : class$java$lang$String;
            }
            return class$projections$gui$FormattedNumber == null ? (class$projections$gui$FormattedNumber = EntryPointWindow.class$("projections.gui.FormattedNumber")) : class$projections$gui$FormattedNumber;
        }

        public Object getValueAt(int n, int n2) {
            return ((EntryPointWindow)EntryPointWindow.this).data[n].value[n2];
        }
    }

    private class NameRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setHorizontalAlignment(0);
            this.setEnabled(jTable == null || jTable.isEnabled());
            if (EntryPointWindow.this.data != null && EntryPointWindow.this.data[n] != null) {
                this.setForeground(((EntryPointWindow)EntryPointWindow.this).data[n].color);
            }
            this.setBackground(EntryPointWindow.this.BACKGROUND);
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this;
        }
    }

    private class RowData {
        Object[] value;
        Color color;

        public RowData() {
            this.value = new Object[EntryPointWindow.this.numCols];
        }
    }
}

