/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JColorChooser;
import projections.gui.ColorPanel;
import projections.gui.ColorSelectWindow;
import projections.gui.ColorSelectable;
import projections.gui.ColorWindowFrame;
import projections.gui.GrayPanel;
import projections.gui.LWPanel;
import projections.gui.Util;

public class EntrySelectionDialog
extends ColorWindowFrame
implements ActionListener {
    private ColorSelectWindow colorSelectWindow;
    private ColorSelectable callbackTarget;
    private ColorPanel[][] entryPointColors;
    private Checkbox[][] entryPointSelection;
    private ColorPanel selectedCP;
    private Button bAll;
    private Button bClear;
    private Button bSave;
    private Button bCancel;
    private int numTypes;
    private String[] typeLabelStrings;
    private int numEPs;
    private boolean[][] stateArray;
    private Color[][] colorArray;
    private boolean[][] existsArray;
    private String[] entryNames;
    private boolean layoutComplete = false;

    public EntrySelectionDialog(Frame frame, String[] stringArray, boolean[][] blArray, Color[][] colorArray, boolean[][] blArray2, String[] stringArray2) {
        this(frame, null, stringArray, blArray, colorArray, blArray2, stringArray2);
    }

    public EntrySelectionDialog(Frame frame, ColorSelectable colorSelectable, String[] stringArray, boolean[][] blArray, Color[][] colorArray, boolean[][] blArray2, String[] stringArray2) {
        super(frame);
        this.callbackTarget = colorSelectable;
        this.numTypes = stringArray.length;
        this.typeLabelStrings = stringArray;
        this.numEPs = blArray[this.numTypes - 1].length;
        this.stateArray = blArray;
        this.colorArray = colorArray;
        this.existsArray = blArray2;
        this.entryNames = stringArray2;
        this.entryPointColors = new ColorPanel[this.numTypes][this.numEPs];
        this.entryPointSelection = new Checkbox[this.numTypes][this.numEPs];
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                EntrySelectionDialog.this.closeDialog();
            }
        });
    }

    public void showDialog() {
        if (this.layoutComplete) {
            this.setVisible(true);
        } else {
            this.setBackground(Color.lightGray);
            this.setTitle("Select Display Items");
            this.setLocation(0, 0);
            this.createLayout();
            this.pack();
            this.setVisible(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof ColorPanel) {
            this.selectedCP = (ColorPanel)actionEvent.getSource();
            String string = "";
            string = this.entryNames[this.selectedCP.getIndex()];
            string = string + " : " + this.typeLabelStrings[this.selectedCP.getType()];
            JColorChooser jColorChooser = new JColorChooser();
            Color color = JColorChooser.showDialog(this, string, this.selectedCP.getColor());
            if (color != null) {
                this.selectedCP.setColor(color);
            }
        } else if (actionEvent.getSource() instanceof Button) {
            Button button = (Button)actionEvent.getSource();
            if (button == this.bAll || button == this.bClear) {
                boolean bl = button == this.bAll;
                int n = 0;
                while (n < this.numTypes) {
                    int n2 = 0;
                    while (n2 < this.numEPs) {
                        if (this.existsArray[n][n2]) {
                            this.entryPointSelection[n][n2].setState(bl);
                        }
                        ++n2;
                    }
                    ++n;
                }
            } else if (button == this.bCancel) {
                this.closeDialog();
            } else if (button == this.bSave) {
                int n = 0;
                while (n < this.numTypes) {
                    int n3 = 0;
                    while (n3 < this.numEPs) {
                        if (this.existsArray[n][n3]) {
                            this.colorArray[n][n3] = this.entryPointColors[n][n3].getColor();
                            this.stateArray[n][n3] = this.entryPointSelection[n][n3].getState();
                        }
                        ++n3;
                    }
                    ++n;
                }
                if (this.callbackTarget != null) {
                    this.callbackTarget.applyDialogColors();
                }
                this.hide();
            }
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        int n = 0;
        while (n < this.numTypes) {
            int n2 = 0;
            while (n2 < this.numEPs) {
                if (this.existsArray[n][n2]) {
                    this.entryPointSelection[n][n2].setState(this.stateArray[n][n2]);
                    this.entryPointColors[n][n2].setColor(this.colorArray[n][n2]);
                }
                ++n2;
            }
            ++n;
        }
        this.dispose();
    }

    private void createLayout() {
        int n = 0;
        while (n < this.numTypes) {
            int n2 = 0;
            while (n2 < this.numEPs) {
                if (this.existsArray[n][n2]) {
                    this.entryPointSelection[n][n2] = new Checkbox();
                    this.entryPointSelection[n][n2].setState(this.stateArray[n][n2]);
                    this.entryPointColors[n][n2] = new ColorPanel(n, n2, this.colorArray[n][n2]);
                    this.entryPointColors[n][n2].addActionListener(this);
                }
                ++n2;
            }
            ++n;
        }
        Panel panel = new Panel();
        this.add("Center", panel);
        panel.setBackground(Color.gray);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        Label label = new Label("USAGE NOTES:");
        Label label2 = new Label("- Modify colors by clicking on color button.");
        Label label3 = new Label("- Click on check box to select an EP to display.");
        Label label4 = new Label("- EPs that are not used during execution are not presented here.");
        label.setFont(new Font("SansSerif", 0, 10));
        label2.setFont(new Font("SansSerif", 0, 10));
        label3.setFont(new Font("SansSerif", 0, 10));
        label4.setFont(new Font("SansSerif", 0, 10));
        ScrollPane scrollPane = new ScrollPane();
        GrayPanel grayPanel = new GrayPanel();
        grayPanel.setLayout(gridBagLayout);
        Util.gblAdd(grayPanel, scrollPane, gridBagConstraints, 0, 0, 1, 1, 1, 1, 5, 5, 0, 5);
        Util.gblAdd(grayPanel, label, gridBagConstraints, 0, 1, 1, 1, 1, 0, 0, 5, -1, 5);
        Util.gblAdd(grayPanel, label2, gridBagConstraints, 0, 2, 1, 1, 1, 0, 0, 5, -1, 5);
        Util.gblAdd(grayPanel, label3, gridBagConstraints, 0, 3, 1, 1, 1, 0, 0, 5, -1, 5);
        Util.gblAdd(grayPanel, label4, gridBagConstraints, 0, 4, 1, 1, 1, 0, 0, 5, 5, 5);
        Label[] labelArray = new Label[this.numTypes];
        int n3 = 0;
        while (n3 < this.numTypes) {
            labelArray[n3] = new Label(this.typeLabelStrings[n3], 1);
            ++n3;
        }
        LWPanel lWPanel = new LWPanel();
        scrollPane.add(lWPanel);
        lWPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        int n4 = 0;
        while (n4 < this.numTypes) {
            Util.gblAdd(lWPanel, labelArray[n4], gridBagConstraints, 1 + 2 * n4, 0, 2, 1, 1, 0);
            ++n4;
        }
        int n5 = 1;
        gridBagConstraints.fill = 1;
        int n6 = 0;
        while (n6 < this.numEPs) {
            int n7 = 0;
            if (this.someExists(n6)) {
                gridBagConstraints.anchor = 10;
                gridBagConstraints.fill = 1;
                Label label5 = new Label(this.entryNames[n6], 2);
                Util.gblAdd(lWPanel, label5, gridBagConstraints, n7++, n5, 1, 1, 1, 0, 0, 2, 0, 5);
                int n8 = 0;
                while (n8 < this.numTypes) {
                    if (this.existsArray[n8][n6]) {
                        gridBagConstraints.fill = 3;
                        gridBagConstraints.anchor = 13;
                        Util.gblAdd(lWPanel, this.entryPointSelection[n8][n6], gridBagConstraints, n7++, n5, 1, 1, 1, 0, 0, 0, 0, 0);
                        gridBagConstraints.anchor = 17;
                        Util.gblAdd(lWPanel, this.entryPointColors[n8][n6], gridBagConstraints, n7++, n5, 1, 1, 1, 0, 0, 0, 0, 0);
                    } else {
                        n7 += 2;
                    }
                    ++n8;
                }
                ++n5;
            }
            ++n6;
        }
        scrollPane.validate();
        GrayPanel grayPanel2 = new GrayPanel();
        grayPanel2.setLayout(new FlowLayout());
        this.bAll = new Button("Select All");
        this.bClear = new Button("Clear All");
        this.bSave = new Button("Save and Exit");
        this.bCancel = new Button("Cancel");
        this.bAll.addActionListener(this);
        this.bClear.addActionListener(this);
        this.bSave.addActionListener(this);
        this.bCancel.addActionListener(this);
        grayPanel2.add(this.bAll);
        grayPanel2.add(this.bClear);
        grayPanel2.add(this.bSave);
        grayPanel2.add(this.bCancel);
        gridBagConstraints.fill = 1;
        Util.gblAdd(panel, grayPanel, gridBagConstraints, 0, 0, 1, 1, 1, 1, 4, 4, 2, 4);
        Util.gblAdd(panel, grayPanel2, gridBagConstraints, 0, 1, 1, 1, 1, 0, 2, 4, 4, 4);
        this.layoutComplete = true;
    }

    private boolean someExists(int n) {
        int n2 = 0;
        while (n2 < this.numTypes) {
            if (this.existsArray[n2][n]) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

