/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JColorChooser;
import projections.gui.ColorPanel;
import projections.gui.ColorSelectWindow;
import projections.gui.ColorWindowFrame;
import projections.gui.GraphData;
import projections.gui.GrayPanel;
import projections.gui.LWPanel;
import projections.gui.Util;
import projections.gui.ZItem;

public class GraphAttributesWindow
extends ColorWindowFrame
implements ActionListener {
    private ColorSelectWindow colorSelectWindow;
    private GraphData data;
    private Checkbox[] cbSystemUsage;
    private ColorPanel[] cpSystemUsage;
    private ColorPanel[][] cpSystemMsgs;
    private ColorPanel[][] cpUserEntry;
    private Checkbox[][] cbSystemMsgs;
    private Checkbox[][] cbUserEntry;
    private ColorPanel selectedCP;
    private GrayPanel p1;
    private GrayPanel p2;
    private GrayPanel p4;
    private Button bAll;
    private Button bClear;
    private Button bApply;
    private Button bClose;

    public GraphAttributesWindow(Frame frame, GraphData graphData) {
        super(frame);
        this.data = graphData;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GraphAttributesWindow.this.Close();
            }
        });
        this.setBackground(Color.lightGray);
        this.setTitle("Select Display Items");
        this.setLocation(0, 0);
        this.CreateLayout();
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof ColorPanel) {
            this.selectedCP = (ColorPanel)actionEvent.getSource();
            String string = "TEST";
            int n = 0;
            while (n < 3) {
                if (this.selectedCP == this.cpSystemUsage[n]) {
                    string = this.data.systemUsage[n].name;
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < 5) {
                int n3 = 0;
                while (n3 < 2) {
                    if (this.selectedCP == this.cpSystemMsgs[n2][n3]) {
                        string = this.data.systemMsgs[n2][n3].name;
                        string = string + this.data.systemMsgs[n2][n3].type;
                    }
                    ++n3;
                }
                ++n2;
            }
            int n4 = 0;
            while (n4 < this.data.numUserEntries) {
                int n5 = 0;
                while (n5 < 2) {
                    if (this.selectedCP == this.cpUserEntry[n4][n5]) {
                        string = this.data.userEntry[n4][n5].name;
                        string = string + this.data.userEntry[n4][n5].type;
                    }
                    ++n5;
                }
                ++n4;
            }
            JColorChooser jColorChooser = new JColorChooser();
            Color color = JColorChooser.showDialog(this, string, this.selectedCP.getColor());
            if (color != null) {
                this.selectedCP.setColor(color);
            }
        } else if (actionEvent.getSource() instanceof Button) {
            Button button = (Button)actionEvent.getSource();
            if (button == this.bAll || button == this.bClear) {
                boolean bl = button == this.bAll;
                int n = 0;
                while (n < 3) {
                    if (null != this.cbSystemUsage[n]) {
                        this.cbSystemUsage[n].setState(bl);
                    }
                    ++n;
                }
                int n6 = 0;
                while (n6 < 5) {
                    if (null != this.cbSystemMsgs[n6][0]) {
                        this.cbSystemMsgs[n6][0].setState(bl);
                        this.cbSystemMsgs[n6][1].setState(bl);
                    }
                    ++n6;
                }
                int n7 = 0;
                while (n7 < this.data.numUserEntries) {
                    if (null != this.cbUserEntry[n7][0]) {
                        this.cbUserEntry[n7][0].setState(bl);
                        this.cbUserEntry[n7][1].setState(bl);
                    }
                    ++n7;
                }
            } else if (button == this.bClose) {
                this.Close();
            } else if (button == this.bApply) {
                int n;
                int n8;
                int n9;
                int n10 = 0;
                int n11 = 0;
                while (n11 < 3) {
                    if (null != this.cbSystemUsage[n11]) {
                        this.data.systemUsage[n11].state = this.cbSystemUsage[n11].getState();
                        this.data.systemUsage[n11].color = this.cpSystemUsage[n11].getColor();
                        if (this.data.systemUsage[n11].state && this.data.systemUsage[n11].exists) {
                            ++n10;
                        }
                    }
                    ++n11;
                }
                int n12 = 0;
                while (n12 < 5) {
                    if (null != this.cbSystemMsgs[n12][0]) {
                        n9 = 0;
                        while (n9 < 3) {
                            if (n9 < 2) {
                                this.data.systemMsgs[n12][n9].state = this.cbSystemMsgs[n12][n9].getState();
                                this.data.systemMsgs[n12][n9].color = this.cpSystemMsgs[n12][n9].getColor();
                            } else {
                                this.data.systemMsgs[n12][2].state = this.data.systemMsgs[n12][0].state || this.data.systemMsgs[n12][1].state;
                                this.data.systemMsgs[n12][2].color = this.data.systemMsgs[n12][0].color;
                            }
                            if (this.data.systemMsgs[n12][n9].state && this.data.systemMsgs[n12][n9].exists) {
                                ++n10;
                            }
                            ++n9;
                        }
                    }
                    ++n12;
                }
                n9 = 0;
                while (n9 < this.data.numUserEntries) {
                    if (null != this.cbUserEntry[n9][0]) {
                        n8 = 0;
                        while (n8 < 3) {
                            if (n8 < 2) {
                                this.data.userEntry[n9][n8].state = this.cbUserEntry[n9][n8].getState();
                                this.data.userEntry[n9][n8].color = this.cpUserEntry[n9][n8].getColor();
                            } else {
                                this.data.userEntry[n9][2].state = this.data.userEntry[n9][0].state || this.data.userEntry[n9][1].state;
                                this.data.userEntry[n9][2].color = this.data.userEntry[n9][0].color;
                            }
                            if (this.data.userEntry[n9][n8].state && this.data.userEntry[n9][n8].exists) {
                                ++n10;
                            }
                            ++n8;
                        }
                    }
                    ++n9;
                }
                this.data.onGraph = new ZItem[n10];
                n8 = 0;
                int n13 = 0;
                while (n13 < 3) {
                    if (this.data.systemUsage[n13].exists && this.data.systemUsage[n13].state) {
                        this.data.onGraph[n8++] = this.data.systemUsage[n13];
                    }
                    ++n13;
                }
                int n14 = 0;
                while (n14 < 5) {
                    n = 0;
                    while (n < 3) {
                        if (this.data.systemMsgs[n14][n].exists && this.data.systemMsgs[n14][n].state) {
                            this.data.onGraph[n8++] = this.data.systemMsgs[n14][n];
                        }
                        ++n;
                    }
                    ++n14;
                }
                n = 0;
                while (n < this.data.numUserEntries) {
                    int n15 = 0;
                    while (n15 < 3) {
                        if (this.data.userEntry[n][n15].exists && this.data.userEntry[n][n15].state) {
                            this.data.onGraph[n8++] = this.data.userEntry[n][n15];
                        }
                        ++n15;
                    }
                    ++n;
                }
                this.data.setData();
                this.data.legendPanel.UpdateLegend();
                this.data.displayPanel.setAllBounds();
                this.data.displayPanel.UpdateDisplay();
            }
        }
    }

    public void Close() {
        int n;
        this.setVisible(false);
        int n2 = 0;
        while (n2 < 3) {
            if (this.cbSystemUsage[n2] != null) {
                this.cbSystemUsage[n2].setState(this.data.systemUsage[n2].state);
                this.cpSystemUsage[n2].setColor(this.data.systemUsage[n2].color);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < 5) {
            if (null != this.cbSystemMsgs[n3][0]) {
                n = 0;
                while (n < 2) {
                    this.cbSystemMsgs[n3][n].setState(this.data.systemMsgs[n3][n].state);
                    this.cpSystemMsgs[n3][n].setColor(this.data.systemMsgs[n3][n].color);
                    ++n;
                }
            }
            ++n3;
        }
        n = 0;
        while (n < this.data.numUserEntries) {
            if (null != this.cbUserEntry[n][0]) {
                int n4 = 0;
                while (n4 < 2) {
                    this.cbUserEntry[n][n4].setState(this.data.userEntry[n][n4].state);
                    this.cpUserEntry[n][n4].setColor(this.data.userEntry[n][n4].color);
                    ++n4;
                }
            }
            ++n;
        }
    }

    private void CreateLayout() {
        Object object;
        Component component;
        int n;
        this.cbSystemUsage = new Checkbox[3];
        this.cpSystemUsage = new ColorPanel[3];
        int n2 = 0;
        while (n2 < 3) {
            if (this.data.systemUsage[n2].exists) {
                this.cbSystemUsage[n2] = new Checkbox();
                this.cbSystemUsage[n2].setState(this.data.systemUsage[n2].state);
                this.cpSystemUsage[n2] = new ColorPanel(this.data.systemUsage[n2].color);
                this.cpSystemUsage[n2].addActionListener(this);
            }
            ++n2;
        }
        this.cbSystemMsgs = new Checkbox[5][2];
        this.cpSystemMsgs = new ColorPanel[5][2];
        int n3 = 0;
        while (n3 < 5) {
            n = 0;
            while (n < 2) {
                if (this.data.systemMsgs[n3][0].exists || this.data.systemMsgs[n3][1].exists) {
                    this.cbSystemMsgs[n3][n] = new Checkbox();
                    this.cbSystemMsgs[n3][n].setState(this.data.systemMsgs[n3][n].state);
                    this.cpSystemMsgs[n3][n] = new ColorPanel(this.data.systemMsgs[n3][n].color);
                    this.cpSystemMsgs[n3][n].addActionListener(this);
                }
                ++n;
            }
            ++n3;
        }
        this.cbUserEntry = new Checkbox[this.data.numUserEntries][2];
        this.cpUserEntry = new ColorPanel[this.data.numUserEntries][2];
        n = 0;
        while (n < this.data.numUserEntries) {
            int n4 = 0;
            while (n4 < 2) {
                if (this.data.userEntry[n][0].exists || this.data.userEntry[n][1].exists) {
                    this.cbUserEntry[n][n4] = new Checkbox();
                    this.cbUserEntry[n][n4].setState(this.data.userEntry[n][n4].state);
                    this.cpUserEntry[n][n4] = new ColorPanel(this.data.userEntry[n][n4].color);
                    this.cpUserEntry[n][n4].addActionListener(this);
                }
                ++n4;
            }
            ++n;
        }
        Panel panel = new Panel();
        this.add("Center", panel);
        panel.setBackground(Color.gray);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel.setLayout(gridBagLayout);
        this.p1 = new GrayPanel();
        this.p2 = new GrayPanel();
        this.p4 = new GrayPanel();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        Label label = new Label("SYSTEM USAGE", 0);
        label.setFont(new Font("SansSerif", 1, 12));
        this.p1.setLayout(gridBagLayout);
        Util.gblAdd(this.p1, label, gridBagConstraints, 0, 0, 3, 1, 1, 0, 5, 5, 0, 5);
        int n5 = 0;
        while (n5 < 3) {
            if (this.data.systemUsage[n5].exists) {
                component = new Label(this.data.systemUsage[n5].name, 2);
                Util.gblAdd(this.p1, component, gridBagConstraints, 0, n5 + 1, 1, 1, 0, 0, 0, 5, 0, 5);
                Util.gblAdd(this.p1, this.cbSystemUsage[n5], gridBagConstraints, 1, n5 + 1, 1, 1, 0, 0, 0, 0, 0, 0);
                Util.gblAdd(this.p1, this.cpSystemUsage[n5], gridBagConstraints, 2, n5 + 1, 1, 1, 0, 0, 0, 0, 0, 5);
            }
            ++n5;
        }
        component = new ScrollPane();
        Label label2 = new Label("* For a Y-Axis setting of Time:");
        Label label3 = new Label("- System Usage items will not be displayed.");
        Label label4 = new Label("- Selecting Creation AND/OR Processing will display the others.");
        label2.setFont(new Font("SansSerif", 0, 10));
        label3.setFont(new Font("SansSerif", 0, 10));
        label4.setFont(new Font("SansSerif", 0, 10));
        this.p2.setLayout(gridBagLayout);
        Util.gblAdd(this.p2, component, gridBagConstraints, 0, 0, 1, 1, 1, 1, 5, 5, 0, 5);
        Util.gblAdd(this.p2, label2, gridBagConstraints, 0, 1, 1, 1, 1, 0, 0, 5, -1, 5);
        Util.gblAdd(this.p2, label3, gridBagConstraints, 0, 2, 1, 1, 1, 0, 0, 5, -1, 5);
        Util.gblAdd(this.p2, label4, gridBagConstraints, 0, 3, 1, 1, 1, 0, 0, 5, 5, 5);
        Label label5 = new Label("SYSTEM MESSAGES", 0);
        Label label6 = new Label("USER ENTRIES", 0);
        Label label7 = new Label("Creation", 1);
        Label label8 = new Label("Processing", 1);
        label5.setFont(new Font("SansSerif", 1, 12));
        label6.setFont(new Font("SansSerif", 1, 12));
        LWPanel lWPanel = new LWPanel();
        ((Container)component).add(lWPanel);
        lWPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        Util.gblAdd(lWPanel, label7, gridBagConstraints, 1, 0, 2, 1, 1, 0);
        Util.gblAdd(lWPanel, label8, gridBagConstraints, 3, 0, 2, 1, 1, 0);
        Util.gblAdd(lWPanel, label5, gridBagConstraints, 0, 1, 3, 1, 1, 0);
        int n6 = 2;
        int n7 = 0;
        while (n7 < 5) {
            if (this.data.systemMsgs[n7][0].exists) {
                object = new Label(this.data.systemMsgs[n7][0].name, 2);
                gridBagConstraints.anchor = 10;
                gridBagConstraints.fill = 1;
                Util.gblAdd(lWPanel, (Component)object, gridBagConstraints, 0, n6, 1, 1, 1, 0, 0, 2, 0, 5);
                gridBagConstraints.fill = 3;
                gridBagConstraints.anchor = 13;
                Util.gblAdd(lWPanel, this.cbSystemMsgs[n7][0], gridBagConstraints, 1, n6, 1, 1, 0, 0, 0, 0, 0, 0);
                Util.gblAdd(lWPanel, this.cbSystemMsgs[n7][1], gridBagConstraints, 3, n6, 1, 1, 0, 0, 0, 0, 0, 0);
                gridBagConstraints.anchor = 17;
                Util.gblAdd(lWPanel, this.cpSystemMsgs[n7][0], gridBagConstraints, 2, n6, 1, 1, 0, 0, 0, 0, 0, 5);
                Util.gblAdd(lWPanel, this.cpSystemMsgs[n7][1], gridBagConstraints, 4, n6++, 1, 1, 0, 0, 0, 0, 0, 5);
            }
            ++n7;
        }
        object = new String();
        gridBagConstraints.fill = 1;
        Util.gblAdd(lWPanel, label6, gridBagConstraints, 0, n6++, 1, 1, 1, 0);
        int n8 = 0;
        while (n8 < this.data.numUserEntries) {
            if (this.data.userEntry[n8][0].exists || this.data.userEntry[n8][1].exists) {
                Label label9;
                gridBagConstraints.anchor = 10;
                gridBagConstraints.fill = 1;
                if (!this.data.userEntry[n8][0].parent.equals(object)) {
                    object = this.data.userEntry[n8][0].parent;
                    label9 = new Label((String)object, 0);
                    Util.gblAdd(lWPanel, label9, gridBagConstraints, 0, n6++, 3, 1, 1, 0);
                }
                label9 = new Label(this.data.userEntry[n8][0].name, 2);
                Util.gblAdd(lWPanel, label9, gridBagConstraints, 0, n6, 1, 1, 1, 0, 0, 2, 0, 5);
                gridBagConstraints.fill = 3;
                gridBagConstraints.anchor = 13;
                Util.gblAdd(lWPanel, this.cbUserEntry[n8][0], gridBagConstraints, 1, n6, 1, 1, 0, 0, 0, 0, 0, 0);
                Util.gblAdd(lWPanel, this.cbUserEntry[n8][1], gridBagConstraints, 3, n6, 1, 1, 0, 0, 0, 0, 0, 0);
                gridBagConstraints.anchor = 17;
                Util.gblAdd(lWPanel, this.cpUserEntry[n8][0], gridBagConstraints, 2, n6, 1, 1, 0, 0, 0, 0, 0, 5);
                Util.gblAdd(lWPanel, this.cpUserEntry[n8][1], gridBagConstraints, 4, n6++, 1, 1, 0, 0, 0, 0, 0, 5);
            }
            ++n8;
        }
        ((Container)component).validate();
        this.p4.setLayout(new FlowLayout());
        this.bAll = new Button("Select All");
        this.bClear = new Button("Clear All");
        this.bApply = new Button("Apply");
        this.bClose = new Button("Close");
        this.bAll.addActionListener(this);
        this.bClear.addActionListener(this);
        this.bApply.addActionListener(this);
        this.bClose.addActionListener(this);
        this.p4.add(this.bAll);
        this.p4.add(this.bClear);
        this.p4.add(this.bApply);
        this.p4.add(this.bClose);
        gridBagConstraints.fill = 1;
        Util.gblAdd(panel, this.p1, gridBagConstraints, 0, 0, 1, 1, 1, 0, 4, 4, 2, 4);
        Util.gblAdd(panel, this.p2, gridBagConstraints, 0, 1, 1, 1, 1, 1, 2, 4, 2, 4);
        Util.gblAdd(panel, this.p4, gridBagConstraints, 0, 2, 1, 1, 1, 0, 2, 4, 4, 4);
    }
}

