/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import projections.gui.Analysis;
import projections.gui.GraphAttributesWindow;
import projections.gui.GraphControlPanel;
import projections.gui.GraphData;
import projections.gui.GraphDisplayPanel;
import projections.gui.GraphLegendPanel;
import projections.gui.IntervalRangeDialog;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.ProjectionsWindow;
import projections.gui.SwingWorker;
import projections.gui.Util;
import projections.misc.PrintUtils;

public class GraphWindow
extends ProjectionsWindow
implements ActionListener {
    private MainWindow mainWindow;
    private int myWindowID;
    private GraphDisplayPanel displayPanel;
    private GraphControlPanel controlPanel;
    private GraphLegendPanel legendPanel;
    private GraphAttributesWindow attributesWindow;
    private GraphData data;
    private GraphWindow thisWindow = this;
    private int intervalStart = -1;
    private int intervalEnd = -1;
    private long startTime = -1L;
    private long endTime = -1L;
    private int intervalRangeSize;
    private long intervalsize;
    private OrderedIntList processorList;
    private String processorListString;
    private int w;
    private int h;
    private boolean firstTime = true;

    public GraphWindow(MainWindow mainWindow, Integer n) {
        super(mainWindow, n);
        this.setBackground(Color.lightGray);
        this.createLayout();
        this.createMenus();
        this.pack();
        this.setTitle("Projections Graph");
        this.showDialog();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)actionEvent.getSource();
            String string = menuItem.getLabel();
            if (string.equals("Close")) {
                this.close();
            } else if (string.equals("Print Graph")) {
                this.PrintGraph();
            } else if (string.equals("Set Interval Size")) {
                this.showDialog();
            }
        }
    }

    private void createLayout() {
        Panel panel = new Panel();
        this.getContentPane().add("Center", panel);
        panel.setBackground(Color.gray);
        this.displayPanel = new GraphDisplayPanel();
        this.controlPanel = new GraphControlPanel();
        this.legendPanel = new GraphLegendPanel(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        Util.gblAdd(panel, this.displayPanel, gridBagConstraints, 0, 0, 1, 1, 2, 1, 2, 2, 2, 2);
        Util.gblAdd(panel, this.legendPanel, gridBagConstraints, 1, 0, 1, 1, 1, 1, 2, 2, 2, 2);
        Util.gblAdd(panel, this.controlPanel, gridBagConstraints, 0, 1, 2, 1, 1, 0, 2, 2, 2, 2);
    }

    private void createMenus() {
        MenuBar menuBar = new MenuBar();
        menuBar.add(Util.makeMenu("File", new Object[]{"Print Graph", null, "Close"}, this));
        menuBar.add(Util.makeMenu("Tools", new Object[]{"Set Interval Size", "Timeline"}, this));
        Menu menu = new Menu("Help");
        menuBar.add(Util.makeMenu(menu, new Object[]{"Index", "About"}, this));
        menuBar.setHelpMenu(menu);
        this.setMenuBar(menuBar);
    }

    public Color getGraphColor(int n) {
        if (this.data != null && this.data.userEntry != null) {
            return this.data.userEntry[n][0].color;
        }
        return null;
    }

    public long getIntervalSize() {
        return this.intervalsize;
    }

    private void PrintGraph() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = new PageFormat();
        pageFormat = printerJob.pageDialog(pageFormat);
        printerJob.setPrintable(new PrintUtils(this.displayPanel), pageFormat);
        if (!printerJob.printDialog()) {
            return;
        }
        try {
            printerJob.print();
        }
        catch (PrinterException printerException) {
            System.err.println("Printer failure.");
        }
    }

    private void setChildDatas() {
        this.controlPanel.setGraphData(this.data);
        this.displayPanel.setGraphData(this.data);
        this.legendPanel.setGraphData(this.data);
        this.data.graphWindow = this;
        this.data.controlPanel = this.controlPanel;
        this.data.displayPanel = this.displayPanel;
        this.data.legendPanel = this.legendPanel;
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new IntervalRangeDialog(this, "Graph Window");
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            if (this.dialog.isModified()) {
                this.setCursor(new Cursor(3));
                SwingWorker swingWorker = new SwingWorker(){

                    public Object construct() {
                        Analysis.LoadGraphData(GraphWindow.this.intervalsize, GraphWindow.this.intervalStart, GraphWindow.this.intervalEnd, true, GraphWindow.this.processorList);
                        GraphWindow.this.data = new GraphData(GraphWindow.this.intervalsize, GraphWindow.this.intervalStart, GraphWindow.this.intervalEnd, GraphWindow.this.processorList);
                        return null;
                    }

                    public void finished() {
                        GraphWindow.this.thisWindow.setChildDatas();
                        if (GraphWindow.this.legendPanel != null) {
                            GraphWindow.this.legendPanel.closeAttributesWindow();
                        }
                        GraphWindow.this.controlPanel.setXMode(((GraphWindow)GraphWindow.this).data.xmode);
                        GraphWindow.this.controlPanel.setYMode(((GraphWindow)GraphWindow.this).data.ymode);
                        GraphWindow.this.legendPanel.UpdateLegend();
                        GraphWindow.this.displayPanel.setAllBounds();
                        GraphWindow.this.displayPanel.UpdateDisplay();
                        GraphWindow.this.thisWindow.setCursor(new Cursor(0));
                        GraphWindow.this.thisWindow.setVisible(true);
                    }
                };
                swingWorker.start();
            } else {
                this.setVisible(true);
            }
        } else {
            return;
        }
    }

    public void showWindow() {
    }

    public void getDialogData() {
        IntervalRangeDialog intervalRangeDialog = (IntervalRangeDialog)this.dialog;
        this.intervalsize = intervalRangeDialog.getIntervalSize();
        this.intervalStart = (int)intervalRangeDialog.getStartInterval();
        this.intervalEnd = (int)intervalRangeDialog.getEndInterval();
        this.processorList = intervalRangeDialog.getValidProcessors();
    }
}

