/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import projections.gui.MainRunStatusPanel;
import projections.gui.MainWindow;
import projections.gui.ScreenInfo;

public class MainSummaryGraphPanel
extends JTabbedPane {
    private MainWindow parent;
    private MainRunStatusPanel statusPanel;
    private JPanel fillerPanel;
    private boolean empty;

    public MainSummaryGraphPanel(MainWindow mainWindow, MainRunStatusPanel mainRunStatusPanel) {
        this.parent = mainWindow;
        this.statusPanel = mainRunStatusPanel;
        this.addChangeListener(this.statusPanel);
        this.fillerPanel = new JPanel();
        this.fillerPanel.setBackground(Color.black);
        this.fillerPanel.setPreferredSize(new Dimension(ScreenInfo.screenWidth / 3, ScreenInfo.screenHeight / 3));
        this.setEmpty();
    }

    public void add(String string, JComponent jComponent, String string2) {
        if (this.empty) {
            this.remove(0);
            this.empty = false;
        }
        this.insertTab(string, null, jComponent, string2, this.getTabCount());
        this.setForegroundAt(0, Color.black);
        this.parent.pack();
    }

    public void removeCurrent() {
        this.remove(this.getSelectedIndex());
        if (this.getTabCount() == 0) {
            this.setEmpty();
        }
    }

    public void removeAll() {
        int n = this.getTabCount();
        int n2 = 0;
        while (n2 < n) {
            this.removeCurrent();
            ++n2;
        }
    }

    public boolean isEmpty() {
        return this.empty;
    }

    private void setEmpty() {
        this.empty = true;
        this.insertTab("No Summary Data Available", null, this.fillerPanel, "No Summary Data loaded", 0);
        this.setForegroundAt(0, Color.red);
        this.setSelectedIndex(0);
        this.parent.pack();
    }

    public Dimension getMinimumSize() {
        return new Dimension(ScreenInfo.screenWidth / 3, ScreenInfo.screenHeight / 3);
    }
}

