/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import projections.analysis.IntervalUtils;
import projections.gui.Analysis;
import projections.gui.AnimationWindow;
import projections.gui.BackGroundImagePanel;
import projections.gui.CommWindow;
import projections.gui.GeneralGraphWindow;
import projections.gui.GraphWindow;
import projections.gui.HelpWindow;
import projections.gui.HistogramWindow;
import projections.gui.InvalidFileDialog;
import projections.gui.LogFileViewerWindow;
import projections.gui.MainFileFilter;
import projections.gui.MainMenuManager;
import projections.gui.MainRunStatusPanel;
import projections.gui.MainSummaryGraphPanel;
import projections.gui.MainTitlePanel;
import projections.gui.MultiRunWindow;
import projections.gui.ProfileWindow;
import projections.gui.ProjectionsWindow;
import projections.gui.ScreenInfo;
import projections.gui.StlWindow;
import projections.gui.SwingWorker;
import projections.gui.TimelineWindow;
import projections.gui.Util;
import projections.gui.graph.Graph;
import projections.gui.graph.GraphPanel;
import projections.gui.graph.SummaryDataSource;
import projections.gui.graph.SummaryXAxis;
import projections.gui.graph.SummaryYAxis;

public class MainWindow
extends JFrame
implements ActionListener {
    private static final int NUM_WINDOWS = 10;
    private static final int GRAPH_WIN = 0;
    private static final int MULTI_WIN = 1;
    private static final int PROFILE_WIN = 2;
    private static final int COMM_WIN = 3;
    private static final int ANIMATION_WIN = 4;
    private static final int LOGVIEW_WIN = 5;
    private static final int HIST_WIN = 6;
    private static final int TIMELINE_WIN = 7;
    private static final int OVERVIEW_WIN = 8;
    private static final int GEN_GRAPH_WIN = 9;
    private static final int DEFAULT_NUM_RUNS = 1;
    public static double CUR_VERSION = 4.0;
    private MainWindow thisWindow = this;
    private JFrame[][] childWindows;
    private String[] toolDescriptions;
    private boolean[][] crossToolMask;
    private GraphWindow graphWindow;
    private TimelineWindow timelineWindow;
    private ProfileWindow profileWindow;
    private CommWindow commWindow;
    private HelpWindow helpWindow;
    private LogFileViewerWindow logFileViewerWindow;
    private HistogramWindow histogramWindow;
    private StlWindow stlWindow;
    private MultiRunWindow multiRunWindow;
    private AnimationWindow animationWindow;
    private GeneralGraphWindow generalGraphWindow;
    private MainTitlePanel titlePanel;
    private BackGroundImagePanel background;
    private MainMenuManager menuManager;
    private MainSummaryGraphPanel summaryGraphPanel;
    private MainRunStatusPanel runStatusPanel;
    private SummaryDataSource sumDataSource;
    private SummaryXAxis sumXAxis;
    private SummaryYAxis sumYAxis;
    private GraphPanel graphPanel;
    private Image bgimage;

    public MainWindow() {
        ScreenInfo.init();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.setBackground(Color.lightGray);
        this.childWindows = new JFrame[1][10];
        this.initializeTools();
        this.menuManager = new MainMenuManager(this);
        this.createLayout();
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    private void initializeTools() {
        this.toolDescriptions = new String[10];
        this.toolDescriptions[0] = "Graph";
        this.toolDescriptions[1] = "Multirun";
        this.toolDescriptions[2] = "Usage Profile";
        this.toolDescriptions[3] = "Communication";
        this.toolDescriptions[5] = "View Logs";
        this.toolDescriptions[6] = "Histograms";
        this.toolDescriptions[4] = "Animation";
        this.toolDescriptions[7] = "Timeline";
        this.toolDescriptions[8] = "Overview";
        this.toolDescriptions[9] = "General Graph";
        this.crossToolMask = new boolean[10][10];
    }

    private void createLayout() {
        Serializable serializable;
        try {
            serializable = this.getClass().getResource("/projections/images/bgimage");
            this.bgimage = Toolkit.getDefaultToolkit().getImage((URL)serializable);
            this.background = new BackGroundImagePanel(this.bgimage, true);
        }
        catch (Exception exception) {
            System.out.println("Error loading background image.  Continuing.");
            this.background = new BackGroundImagePanel(null);
        }
        this.setContentPane(this.background);
        serializable = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.background.setLayout((LayoutManager)((Object)serializable));
        this.titlePanel = new MainTitlePanel(this);
        this.runStatusPanel = new MainRunStatusPanel();
        this.summaryGraphPanel = new MainSummaryGraphPanel(this, this.runStatusPanel);
        Util.gblAdd(this.background, this.titlePanel, gridBagConstraints, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0);
        Util.gblAdd(this.background, this.runStatusPanel, gridBagConstraints, 0, 1, 1, 1, 1, 0, 0, 20, 0, 20);
        Util.gblAdd(this.background, this.summaryGraphPanel, gridBagConstraints, 0, 2, 1, 1, 1, 1, 0, 20, 20, 20);
        this.pack();
    }

    public void menuToolSelected(String string) {
        if (string.equals("Graphs")) {
            this.showChildWindow("GraphWindow", 0);
        } else if (string.equals("Histograms")) {
            this.showChildWindow("HistogramWindow", 6);
        } else if (string.equals("Timelines")) {
            this.showChildWindow("TimelineWindow", 7);
        } else if (string.equals("Usage Profile")) {
            this.showChildWindow("ProfileWindow", 2);
        } else if (string.equals("Communication Histogram")) {
            this.showChildWindow("CommWindow", 3);
        } else if (string.equals("Animation")) {
            this.showChildWindow("AnimationWindow", 4);
        } else if (string.equals("View Log Files")) {
            this.showChildWindow("LogFileViewerWindow", 5);
        } else if (string.equals("Overview")) {
            this.showChildWindow("StlWindow", 8);
        } else if (string.equals("General Graph")) {
            this.showChildWindow("GeneralGraphWindow", 9);
        } else if (string.equals("Multirun Analysis")) {
            this.showChildWindow("MultiRunWindow", 1);
        }
    }

    public void changeBackground() {
        JColorChooser jColorChooser = new JColorChooser();
        Color color = JColorChooser.showDialog(this, "Background Color", Analysis.background);
        if (color != null) {
            Analysis.background = color;
            this.repaintAllWindows();
        }
    }

    public void changeForeground() {
        JColorChooser jColorChooser = new JColorChooser();
        Color color = JColorChooser.showDialog(this, "Foreground Color", Analysis.foreground);
        if (color != null) {
            Analysis.foreground = color;
            this.repaintAllWindows();
        }
    }

    public void setGrayscale() {
        Analysis.setGrayscale();
        this.repaintAllWindows();
    }

    public void setFullColor() {
        Analysis.setFullColor();
        this.repaintAllWindows();
    }

    private void repaintAllWindows() {
        int n = 0;
        while (n < 10) {
            if (this.childWindows[0][n] != null) {
                this.childWindows[0][n].repaint();
            }
            ++n;
        }
        if (this.timelineWindow != null) {
            this.timelineWindow.validate();
        }
        this.repaint();
    }

    public void showChildWindow(String string, int n) {
        block4: {
            try {
                if (this.childWindows[0][n] == null) {
                    String string2 = this.getClass().getPackage().getName() + "." + string;
                    Class<?> clazz = Class.forName(string2);
                    Constructor<?> constructor = clazz.getConstructor(this.getClass(), Class.forName("java.lang.Integer"));
                    this.childWindows[0][n] = (ProjectionsWindow)constructor.newInstance(this, new Integer(n));
                    break block4;
                }
                if (this.childWindows[0][n] instanceof ProjectionsWindow) {
                    ((ProjectionsWindow)this.childWindows[0][n]).showDialog();
                    break block4;
                }
                this.childWindows[0][n].show();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void showOpenFileDialog() {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.setFileFilter(new MainFileFilter());
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.setTitle("Projections -" + jFileChooser.getSelectedFile());
            this.openFile(jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void openFile(String string) {
        final String string2 = string;
        this.sumDataSource = null;
        this.sumXAxis = null;
        this.sumYAxis = null;
        this.graphPanel = null;
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                try {
                    Analysis.initAnalysis(string2, MainWindow.this.thisWindow);
                }
                catch (IOException iOException) {
                    InvalidFileDialog invalidFileDialog = new InvalidFileDialog(MainWindow.this.thisWindow);
                    invalidFileDialog.setVisible(true);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    stringIndexOutOfBoundsException.printStackTrace();
                    InvalidFileDialog invalidFileDialog = new InvalidFileDialog(MainWindow.this.thisWindow);
                    invalidFileDialog.setVisible(true);
                }
                return null;
            }

            public void finished() {
                MainWindow.this.setTitle("Projections - " + string2);
                if (Analysis.hasSummaryData()) {
                    Analysis.loadSummaryData();
                    double[] dArray = Analysis.getSummaryAverageData();
                    long l = Analysis.getSummaryIntervalSize();
                    long l2 = (long)IntervalUtils.getBestIntervalSize(l, dArray.length);
                    if (l2 != l) {
                        IntervalUtils.utilToTime(dArray, (double)l);
                        double[] dArray2 = IntervalUtils.rebin(dArray, (double)l, l2);
                        IntervalUtils.timeToUtil(dArray2, (double)l2);
                        MainWindow.this.sumDataSource = new SummaryDataSource(dArray2);
                        MainWindow.this.sumXAxis = new SummaryXAxis(dArray2.length, l2);
                    } else {
                        MainWindow.this.sumDataSource = new SummaryDataSource(dArray);
                        MainWindow.this.sumXAxis = new SummaryXAxis(dArray.length, Analysis.getSummaryIntervalSize());
                    }
                    MainWindow.this.sumYAxis = new SummaryYAxis();
                    MainWindow.this.graphPanel = new GraphPanel(new Graph(MainWindow.this.sumDataSource, MainWindow.this.sumXAxis, MainWindow.this.sumYAxis));
                    MainWindow.this.summaryGraphPanel.add("data", MainWindow.this.graphPanel, "run data");
                }
                MainWindow.this.menuManager.fileOpened();
            }
        };
        swingWorker.start();
    }

    public void closeChildWindow(int n) {
        this.childWindows[0][n] = null;
    }

    public void shutdown() {
        System.exit(0);
    }

    public void closeCurrent() {
        this.closeAll();
    }

    public void closeAll() {
        this.summaryGraphPanel.removeAll();
        this.menuManager.lastFileClosed();
        this.setTitle("Projections");
    }

    public Color getGraphColor(int n) {
        if (this.graphWindow != null) {
            return this.graphWindow.getGraphColor(n);
        }
        return null;
    }

    public boolean GraphExists() {
        return this.graphWindow != null;
    }

    public static void help() {
        System.out.println("-h:\t\tshow this page");
        System.out.println("-V:\t\tshow Projections version");
        System.out.println("-u <ver>:\tuse old version format");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        String string = null;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-h")) {
                MainWindow.help();
            } else if (stringArray[n].equals("-V")) {
                System.out.println("Projections version: " + Analysis.getVersion());
                System.exit(0);
            } else if (stringArray[n].equals("-u")) {
                double d;
                if (++n == stringArray.length) {
                    MainWindow.help();
                }
                if ((d = Double.parseDouble(stringArray[n])) > CUR_VERSION) {
                    System.out.println("Invalid (future) Projections version!");
                    System.exit(1);
                }
                CUR_VERSION = d;
            } else {
                string = stringArray[n];
            }
            ++n;
        }
        MainWindow mainWindow = new MainWindow();
        mainWindow.pack();
        mainWindow.setTitle("Projections");
        mainWindow.setVisible(true);
        if (string != null) {
            mainWindow.openFile(string);
        }
    }
}

