/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Vector;

public class ProjectionsFileMgr {
    private File[] stsFiles_ = null;
    private File[][] logFiles_ = null;
    String base_ = null;
    String extention_ = null;

    public ProjectionsFileMgr(String[] stringArray) throws IOException {
        this.stsFiles_ = new File[stringArray.length];
        this.logFiles_ = new File[stringArray.length][];
        int n = 0;
        while (n < stringArray.length) {
            this.stsFiles_[n] = new File(stringArray[n]);
            this.logFiles_[n] = this.findFiles(stringArray[n]);
            ++n;
        }
    }

    public ProjectionsFileMgr(Vector vector) throws IOException {
        this.stsFiles_ = new File[vector.size()];
        this.logFiles_ = new File[vector.size()][];
        int n = 0;
        while (n < vector.size()) {
            this.stsFiles_[n] = (File)vector.elementAt(n);
            this.logFiles_[n] = this.findFiles(this.stsFiles_[n].getCanonicalPath());
            ++n;
        }
    }

    public void printSts() throws IOException {
        int n = 0;
        while (n < this.stsFiles_.length) {
            int n2 = 0;
            while (n2 < this.logFiles_[n].length) {
                if (this.logFiles_[n] != null) {
                    // empty if block
                }
                ++n2;
            }
            ++n;
        }
    }

    public File getStsFile(int n) {
        if (this.stsFiles_ != null) {
            return this.stsFiles_[n];
        }
        return null;
    }

    public int getNumFiles() {
        if (this.stsFiles_ != null) {
            return this.stsFiles_.length;
        }
        return 0;
    }

    public File[] getLogFiles(int n) {
        if (this.logFiles_ != null) {
            return this.logFiles_[n];
        }
        return null;
    }

    private File[] findFiles(String string) throws IOException {
        int n;
        File file = new File(string);
        File file2 = new File(file.getParent());
        if (!file2.isDirectory()) {
            return null;
        }
        String string2 = file.getName();
        int n2 = string2.lastIndexOf(".", (n = string2.lastIndexOf(".")) - 1);
        if (n2 != -1) {
            this.base_ = string2.substring(0, n2);
            this.extention_ = string.endsWith(".sts") ? string2.substring(n2 + 1, n) : string2.substring(n + 1, string2.length());
        } else {
            this.base_ = string2.substring(0, n - 1);
            this.extention_ = ".log";
        }
        String[] stringArray = file2.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.startsWith(ProjectionsFileMgr.this.base_) && string.endsWith(ProjectionsFileMgr.this.extention_) && string.indexOf(".sts") == -1;
            }
        });
        File[] fileArray = new File[stringArray.length];
        int n3 = 0;
        while (n3 < fileArray.length) {
            fileArray[n3] = new File(file2, stringArray[n3]);
            ++n3;
        }
        return fileArray;
    }
}

