/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import projections.gui.Analysis;
import projections.gui.TimelineData;

public class TimelineAxisCanvas
extends Canvas {
    private TimelineData data;
    private int axispos;
    private int textpos;
    private String type;
    private FontMetrics fm;
    private Image offscreen;
    private Component component_;
    private long beginCoord_;
    private long endCoord_;
    private DecimalFormat format_ = new DecimalFormat();

    public TimelineAxisCanvas(TimelineData timelineData, String string) {
        this.data = timelineData;
        this.type = string;
        this.component_ = this;
        this.setBackground(Analysis.background);
        this.setForeground(Analysis.foreground);
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                TimelineAxisCanvas.this.component_.setCursor(new Cursor(1));
            }

            public void mouseExited(MouseEvent mouseEvent) {
                TimelineAxisCanvas.this.component_.setCursor(new Cursor(0));
            }
        });
        this.format_.setGroupingUsed(true);
    }

    public double canvasToTime(int n) {
        return (double)((long)n - this.beginCoord_) / (double)(this.endCoord_ - this.beginCoord_) * (double)(this.data.endTime - this.data.beginTime) + (double)this.data.beginTime;
    }

    public Point screenToCanvas(Point point) {
        int n;
        int n2 = point.x;
        int n3 = this.data.timelineWindow.getHSBValue();
        point.x = n = n3 + n2;
        return point;
    }

    public int calcHSBOffset(double d) {
        double d2 = (d - (double)this.data.beginTime) / (double)(this.data.endTime - this.data.beginTime);
        double d3 = d2 * (double)(this.endCoord_ - this.beginCoord_);
        return (int)(d3 + (double)this.beginCoord_ + 0.5);
    }

    public void makeNewImage() {
        this.offscreen = null;
        if (this.data.tlw > 0 && this.data.ath > 0) {
            this.offscreen = this.createImage(this.data.tlw, this.data.ath);
            if (this.offscreen == null) {
                return;
            }
            Graphics graphics = this.offscreen.getGraphics();
            graphics.setClip(0, 0, this.data.tlw, this.data.ath);
            Color color = graphics.getColor();
            graphics.setColor(Analysis.background);
            graphics.fillRect(0, 0, this.data.tlw, this.data.ath);
            graphics.setColor(color);
            if (this.fm == null) {
                this.fm = graphics.getFontMetrics(graphics.getFont());
                if (this.type.equals("top")) {
                    this.axispos = this.data.ath - 10;
                    this.textpos = this.axispos - 10;
                } else {
                    this.axispos = 10;
                    this.textpos = this.axispos + 10 + this.fm.getHeight();
                }
            }
            if (this.type.equals("top") && this.data.numPs > 1 || this.type.equals("bot") && this.data.numPs > 0) {
                long l = (long)this.data.timeIncrement - this.data.beginTime % (long)this.data.timeIncrement;
                if (l == (long)this.data.timeIncrement) {
                    l = 0L;
                }
                int n = this.data.offset + (int)((double)(this.data.endTime - this.data.beginTime) * this.data.pixelIncrement / (double)this.data.timeIncrement);
                graphics.setColor(Analysis.foreground);
                graphics.drawLine(this.data.offset, this.axispos, n, this.axispos);
                this.beginCoord_ = this.data.offset;
                this.endCoord_ = n;
                int n2 = 0;
                while (n2 < this.data.numIntervals) {
                    int n3 = this.data.offset + (int)((double)n2 * this.data.pixelIncrement) + (int)((double)l * this.data.pixelIncrement / (double)this.data.timeIncrement);
                    if (n3 > n) break;
                    if (n2 % this.data.labelIncrement == 0) {
                        String string = this.format_.format(this.data.beginTime + l + (long)n2 * (long)this.data.timeIncrement);
                        graphics.drawLine(n3, this.axispos - 5, n3, this.axispos + 5);
                        graphics.drawString(string, n3 - this.fm.stringWidth(string) / 2, this.textpos);
                    } else {
                        graphics.drawLine(n3, this.axispos - 2, n3, this.axispos + 2);
                    }
                    ++n2;
                }
            }
            graphics.dispose();
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        if (this.offscreen != null) {
            int n = this.data.timelineWindow.getHSBValue();
            graphics.drawImage(this.offscreen, 0, 0, this.data.vpw, this.data.ath, n, 0, n + this.data.vpw, this.data.ath, null);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

