/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JColorChooser;
import projections.gui.Analysis;
import projections.gui.ColorPanel;
import projections.gui.ColorSelectWindow;
import projections.gui.ColorWindowFrame;
import projections.gui.LWPanel;
import projections.gui.TimelineData;
import projections.gui.Util;

public class TimelineColorWindow
extends ColorWindowFrame
implements ActionListener {
    private TimelineData data;
    private String[][] names;
    private ColorPanel[] cpEntry;
    private ColorPanel selectedCP;
    private Button bApply;
    private Button bClose;
    private Button bGraphColors;
    private ColorSelectWindow colorSelectWindow;

    public TimelineColorWindow(Frame frame, TimelineData timelineData) {
        super(frame);
        this.data = timelineData;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TimelineColorWindow.this.Close();
            }
        });
        this.setBackground(Color.lightGray);
        this.setTitle("Timeline Colors");
        this.setLocation(0, 0);
        this.CreateLayout();
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof Button) {
            Button button = (Button)actionEvent.getSource();
            if (button == this.bApply) {
                int n = 0;
                while (n < Analysis.getNumUserEntries()) {
                    if (this.cpEntry[n] != null) {
                        this.data.entryColor[n] = this.cpEntry[n].getColor();
                    }
                    ++n;
                }
                this.data.displayCanvas.updateColors();
            } else if (button == this.bClose) {
                this.Close();
            } else if (button == this.bGraphColors && this.GraphExists()) {
                int n = 0;
                while (n < Analysis.getNumUserEntries()) {
                    if (this.cpEntry[n] != null) {
                        this.cpEntry[n].setColor(this.getGraphColor(n));
                    }
                    ++n;
                }
            }
        } else if (actionEvent.getSource() instanceof ColorPanel) {
            this.selectedCP = (ColorPanel)actionEvent.getSource();
            String string = null;
            int n = 0;
            while (n < Analysis.getNumUserEntries()) {
                if (this.selectedCP == this.cpEntry[n]) {
                    string = this.names[n][0];
                }
                ++n;
            }
            JColorChooser jColorChooser = new JColorChooser();
            Color color = JColorChooser.showDialog(this, string, this.selectedCP.getColor());
            if (color != null) {
                this.selectedCP.setColor(color);
            }
        }
    }

    private void Close() {
        this.setVisible(false);
        this.data.timelineWindow.CloseColorWindow();
        this.dispose();
    }

    private void CreateLayout() {
        Component component;
        Panel panel = new Panel();
        this.add("Center", panel);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.names = Analysis.getEntryNames();
        this.cpEntry = new ColorPanel[Analysis.getNumUserEntries()];
        LWPanel lWPanel = new LWPanel();
        lWPanel.setLayout(gridBagLayout);
        int n = 0;
        String string = new String();
        int n2 = 0;
        while (n2 < Analysis.getNumUserEntries()) {
            if (this.data.entries[n2] > 0) {
                if (!string.equals(this.names[n2][1])) {
                    string = this.names[n2][1];
                    component = new Label(this.names[n2][1], 0);
                    Util.gblAdd(lWPanel, component, gridBagConstraints, 0, n++, 1, 1, 1, 0, 0, 5, 0, 5);
                }
                component = new Label(this.names[n2][0], 2);
                Util.gblAdd(lWPanel, component, gridBagConstraints, 0, n, 1, 1, 1, 0, 0, 5, 0, 5);
                this.cpEntry[n2] = new ColorPanel(this.data.entryColor[n2]);
                Util.gblAdd(lWPanel, this.cpEntry[n2], gridBagConstraints, 1, n++, 1, 1, 0, 0, 0, 5, 0, 5);
                this.cpEntry[n2].addActionListener(this);
            }
            ++n2;
        }
        Util.gblAdd(lWPanel, new Label(""), gridBagConstraints, 0, n, 1, 1, 1, 1);
        component = new ScrollPane();
        component.add(lWPanel);
        GrayLWPanel grayLWPanel = new GrayLWPanel();
        grayLWPanel.setLayout(gridBagLayout);
        Util.gblAdd(grayLWPanel, component, gridBagConstraints, 0, 0, 1, 1, 1, 1, 5, 5, 5, 5);
        GrayLWPanel grayLWPanel2 = new GrayLWPanel();
        grayLWPanel2.setLayout(new FlowLayout());
        this.bGraphColors = new Button("Use Graph colors");
        grayLWPanel2.add(this.bGraphColors);
        if (this.GraphExists()) {
            this.bGraphColors.addActionListener(this);
        } else {
            this.bGraphColors.setForeground(Color.gray);
        }
        this.bApply = new Button("Apply");
        this.bApply.addActionListener(this);
        grayLWPanel2.add(this.bApply);
        this.bClose = new Button("Close");
        this.bClose.addActionListener(this);
        grayLWPanel2.add(this.bClose);
        panel.setLayout(gridBagLayout);
        Util.gblAdd(panel, grayLWPanel, gridBagConstraints, 0, 0, 1, 1, 1, 1, 4, 4, 2, 4);
        Util.gblAdd(panel, grayLWPanel2, gridBagConstraints, 0, 1, 1, 1, 1, 0, 2, 4, 4, 4);
    }

    private Color getGraphColor(int n) {
        return this.data.timelineWindow.getGraphColor(n);
    }

    private boolean GraphExists() {
        return this.data.timelineWindow.GraphExists();
    }

    class GrayLWPanel
    extends LWPanel {
        GrayLWPanel() {
        }

        public void paint(Graphics graphics) {
            graphics.setColor(Color.lightGray);
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
            super.paint(graphics);
        }
    }
}

