/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.graph;

import java.awt.Color;
import projections.analysis.MultiRunDataAnalyzer;
import projections.gui.graph.DataSource;

public class MultiRunDataSource
extends DataSource {
    double[][] dataValues;
    int dataType;
    Color[] colorMap = null;
    String title;
    MultiRunDataAnalyzer parent;

    public MultiRunDataSource(MultiRunDataAnalyzer multiRunDataAnalyzer, double[][] dArray, int n, Color[] colorArray, String string) {
        this.parent = multiRunDataAnalyzer;
        this.dataValues = dArray;
        this.dataType = n;
        this.colorMap = colorArray;
        this.title = string;
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        return "";
    }

    public int getIndexCount() {
        if (this.dataValues != null) {
            return this.dataValues.length;
        }
        return 0;
    }

    public int getValueCount() {
        if (this.dataValues != null) {
            return this.dataValues[0].length;
        }
        return 0;
    }

    public Color getColor(int n) {
        if (this.colorMap == null) {
            return super.getColor(n);
        }
        return this.colorMap[n];
    }

    public Color[] getColorMap() {
        if (this.colorMap == null) {
            Color[] colorArray = new Color[this.getValueCount()];
            int n = 0;
            while (n < colorArray.length) {
                colorArray[n] = super.getColor(n);
                ++n;
            }
            return colorArray;
        }
        return this.colorMap;
    }

    public void getValues(int n, double[] dArray) {
        int n2 = 0;
        while (n2 < this.getValueCount()) {
            dArray[n2] = this.dataValues[n][n2];
            ++n2;
        }
    }

    public String[] getPopup(int n, int n2) {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getPopup(n, n2, this.dataType);
    }

    public void setColors(Color[] colorArray) {
        this.colorMap = colorArray;
    }
}

