/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.fmt;

import charm.debug.fmt.PAbstract;
import charm.debug.fmt.PDisplayStyle;

public class PList
extends PAbstract {
    private PAbstract head;
    private PAbstract tail;

    PList() {
        this.emptyList();
    }

    public void emptyList() {
        this.tail = null;
        this.head = null;
    }

    public void add(PAbstract pAbstract) {
        if (this.tail == null) {
            this.head = this.tail = pAbstract;
        } else {
            this.tail.setNext(pAbstract);
            this.tail = pAbstract;
        }
    }

    public int size() {
        int n = 0;
        PAbstract pAbstract = this.head;
        while (pAbstract != null) {
            ++n;
            pAbstract = pAbstract.getNext();
        }
        return n;
    }

    public PAbstract elementAt(int n) {
        int n2 = 0;
        PAbstract pAbstract = this.head;
        while (pAbstract != null) {
            if (n2 == n) {
                return pAbstract;
            }
            ++n2;
            pAbstract = pAbstract.getNext();
        }
        return null;
    }

    public PAbstract elementNamed(String string) {
        PAbstract pAbstract = this.head;
        while (pAbstract != null) {
            if (pAbstract.getName().equals(string)) {
                return pAbstract;
            }
            pAbstract = pAbstract.getNext();
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString() + "{");
        PAbstract pAbstract = this.head;
        while (pAbstract != null) {
            stringBuffer.append(pAbstract.toString());
            if (pAbstract.getNext() != null) {
                stringBuffer.append(", ");
            }
            pAbstract = pAbstract.getNext();
        }
        stringBuffer.append("} ");
        return stringBuffer.toString();
    }

    private boolean hasFew() {
        return this.head == this.tail;
    }

    public boolean draw(PDisplayStyle pDisplayStyle, int n) {
        if (!this.hasFew()) {
            super.draw(pDisplayStyle, n);
            pDisplayStyle.drawString("{");
        }
        if (n == 1) {
            pDisplayStyle.addIndent(1);
            PAbstract pAbstract = this.head;
            while (pAbstract != null) {
                pAbstract.draw(pDisplayStyle);
                if (pAbstract.getNext() != null) {
                    pDisplayStyle.newRow();
                }
                pAbstract = pAbstract.getNext();
            }
            pDisplayStyle.addIndent(-1);
        } else {
            PAbstract pAbstract = this.head;
            while (pAbstract != null) {
                if (!pAbstract.draw(pDisplayStyle)) {
                    return false;
                }
                pAbstract = pAbstract.getNext();
            }
        }
        if (!this.hasFew()) {
            pDisplayStyle.drawString("}");
        }
        return true;
    }
}

