/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.fmt;

import charm.debug.fmt.PAbstract;
import charm.debug.fmt.PDisplayStyle;

public class PNative
extends PAbstract {
    private float[] v_float;
    private int[] v_int;
    private int len;

    PNative(int[] nArray) {
        this.v_int = nArray;
        this.v_float = null;
        this.len = nArray.length;
    }

    PNative(float[] fArray) {
        this.v_int = null;
        this.v_float = fArray;
        this.len = fArray.length;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        if (this.len > 1) {
            stringBuffer.append("{");
        }
        int n = 0;
        while (n < this.len) {
            if (this.v_int != null) {
                stringBuffer.append("" + this.v_int[n]);
            }
            if (this.v_float != null) {
                stringBuffer.append("" + this.v_float[n]);
            }
            if (n + 1 != this.len) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        if (this.len > 1) {
            stringBuffer.append("} ");
        }
        return stringBuffer.toString();
    }

    public int getIntValue(int n) {
        return this.v_int[n];
    }

    public boolean draw(PDisplayStyle pDisplayStyle, int n) {
        super.draw(pDisplayStyle, n);
        int n2 = 0;
        while (n2 < this.len) {
            String string = "??";
            if (this.v_int != null) {
                string = Integer.toString(this.v_int[n2]);
            }
            if (this.v_float != null) {
                string = Float.toString(this.v_float[n2]);
            }
            if (!pDisplayStyle.drawString(string)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

