#include <iostream>
#include <ampi.h>
#include <charm++.h>

int
main(int argc, char** argv)
{
  int *winArea;

  MPI_Init(&argc, &argv);
  int rank = 0;
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);

  int size = 4;
  MPI_Alloc_mem(sizeof(int)*size, MPI_INFO_NULL, &winArea);
  MPI_Win win;
  MPI_Win_create((void*)winArea, sizeof(int), sizeof(int),
		  MPI_INFO_NULL, MPI_COMM_WORLD, &win);

  for (int i = 0; i < size; ++i) {
    winArea[i] = i;
  }
  MPI_Win_fence(0, win);
  CkPrintf("[%d] MPI_Win_fence\n", rank);

  MPI_Win_free(&win);
  MPI_Free_mem((void*)winArea);
  MPI_Finalize();
  return 0;
}
