#include <stdio.h>
#include <stdlib.h>
#include "converse.h"
#include "conv-ccs.h"

int respMax=0;
char *respBuf=NULL;
double delay=0;

/*This function is called in response to a CCS request
 from the network.  The reqData consists of a single
 ASCII integer, which is the number of bytes to 
 send back.
*/
void handler(void *userPtr,int reqLen,const void *reqData)
{
  int i;
  int len=atoi((char *)reqData);
  if (delay>0) {
    double startTime=CmiWallTimer();
    printf("Server got request... sleeping...\n");
    while (CmiWallTimer()<startTime+delay) sleep(0);
    printf("Server back awake again...\n");
  }
  if (len>respMax) len=respMax;
  if (len<0) len=0;
  for (i=0;i<len;i++) respBuf[i]=(char)i;
  CcsSendReply(len,respBuf);
}

void user_main(int argc, char **argv)
{
  respMax=10*1024*1024;
  if (argc>1) respMax=atoi(argv[1]);
  CmiPrintf("Maximimum ping size is %d bytes\n",respMax);
  respBuf=(char *)malloc(respMax);
  CcsRegisterHandlerFn("rttTest", handler, NULL);
  CmiPrintf("CCS Handlers registered.  Waiting for net requests...\n");  
}

main(int argc, char **argv)
{
  ConverseInit(argc, argv, user_main, 0, 0);
}
