/**
 * PorThread:
 *  Portable, trivial threading library.
 * Orion Sky Lawlor, olawlor@acm.org, 2003/4/2
 */
#ifndef __OSL_PORTHREAD_H
#define __OSL_PORTHREAD_H

/**
 * This is the routine executed in the thread.
 */
typedef void (*porthread_fn_t)(void *arg);

/**
 * Call fn(arg) from within a new thread.
 */
void porthread_create(porthread_fn_t fn,void *arg);


/**
 * Suspend the current thread for up to 
 *  this many milliseconds, letting other threads
 *  or processes run.
 */
void porthread_yield(int msec);

#endif

