# tcl_init.tcl
#
# This is the GUI initialization/utility portion.
#
# Orion Sky Lawlor, olawlor@acm.org, 11/27/2001
#

wm withdraw .

################ Window Maintainance ################

proc addMenus {w} {
	# Menu bar section
	set currMenu 0
	menu $w.menubar
	# I'm using TCL-8.0 style menus, so I can attach $w.menubar to $w
	$w configure -menu $w.menubar

	global tcl_platform mod_user modifier
	if {$tcl_platform(platform) == "macintosh"} {
	   set modifier Command; set mod_user Command
	} elseif {$tcl_platform(platform) == "windows"} {
	    set modifier Control; set mod_user Ctrl
	} else {
	    set modifier Meta;set mod_user Meta
	}

	proc makeMenu {w name title under} {
		global currMenu 
		set currMenu $w.menubar.$name
		$w.menubar add cascade -label $title -menu $currMenu -underline $under
		menu $currMenu -tearoff 0
	}

	proc makeCommand {w command label letter underlineNo} {
		global currMenu modifier mod_user
		$currMenu add command -label $label -command $command \
			-accelerator $mod_user+[string toupper $letter] \
			-underline $underlineNo
		bind $w <$modifier-$letter> $command
	}

	############## File Menu (always there) ###############
	makeMenu $w file "File" 0

	if {$tcl_platform(platform) == "macintosh"} {
		makeCommand $w {doQuit} "Quit" q 0
	} else {makeCommand $w {doQuit} "Exit" x 1}
}

proc buildWindow {w name} {
#	catch "destroy $w"
        catch {
			toplevel $w
			wm title $w $name
			wm iconname $w $name
			wm group $w .
		}
}
proc neededWindow {w} {
        bind $w <Destroy> {doQuit}
}
proc buildToplevel {w name} {
	buildWindow $w $name
        addMenus $w
        neededWindow $w
}

proc killWindow {w} {
	catch "destroy $w"
}

# Create a modal text entry dialog box with the given 
# description
proc textDialogBegin {w shortDesc desc default accept reject} {
	buildWindow $w $shortDesc
	
# Set up buttons-- OK, Log, and log file name display
	label $w.desc -text $desc
	pack $w.desc -side top -anchor nw

	frame $w.bf
	pack $w.bf -side bottom -fill x
	
	button $w.bf.accept -text $accept -command {modalEnd}
	pack $w.bf.accept -side right
	bind $w <Key-Return> {modalEnd}
	
	button $w.bf.reject -text $reject -command "
		$w.text delete 0.0 end
		modalEnd
	"
	pack $w.bf.reject -side right
	bind $w <Destroy> {doQuit}

# Set up text field
	text $w.text -wrap word -height 1 -width 50
	$w.text insert 0.0 $default
	pack $w.text -fill both -expand yes
}
proc textDialogGet {w} {
	modalBegin
	set ret [ string trimright [ $w.text get 0.0 end ] ]
	return $ret
}
proc textDialogEnd {w} {
	wm withdraw $w
}

proc fatalError {what} {
	set errtext "Sorry, a fatal error occured:\n"
	append errtext $what
	append errtext {
For support information, contact olawlor@acm.org
}
	tk_dialog .fatalerr_dialog "Fatal Error!" $errtext {} 0 "Exit"
	puts "Tcl GUI exiting after error"
	doQuit
}
proc fatalTcl {} {
  	global errorCode errorInfo
  	fatalError $errorInfo
}

################ commands ###############
proc doQuit {} {
# This one's pretty simple...
	exit 1
}

############# Eval-- catches errors in commands ###########
proc c2tcl_eval args {
  set programResult [catch "eval $args" ]

# Check for abnormal termination
  if {$programResult!=0} {fatalTcl}
}

################## Visualization tools #####################
# These were moved into C++ side because of linking problems
# under Win32.

proc v_step {p} {
	updateMesh
	guiRerender
}


############################################################
#################### Main program ##########################

#c2tcl_eval {buildToplevel .crap "It loaded"}

proc startAppWith {nameStr} {
	set res [ catch "eval createMesh $nameStr" ]
	if {$res} {
		global errorInfo
		puts "Could not connect: $errorInfo"
		doQuit
	}
	buildMain
}

proc startApp {} {
	set loaded 0
	set td .tdw
	textDialogBegin $td "Server" "Please enter the CCS Server to connect to:" "localhost:1234" "Connect" "Exit"
	while {!$loaded} {
		set nameStr [ textDialogGet $td ]
		if {$nameStr==""} {doQuit}
		set loaded 1
		set res [ catch "eval createMesh $nameStr" ]
		if {$res} {
			global errorInfo
			tk_dialog .err_dialog "Could not connect:" $errorInfo {} 0 "OK"
			set loaded 0
		}
	}
	textDialogEnd $td
	buildMain
}

proc setStatus {toWhat} {
	.main.status configure -text "$toWhat"
}

# Create and initialize the main window
proc buildMain {} {
	set w ".main"
	buildToplevel $w "CCS View"
	
	label $w.spacer -text " " -height 12 -width 1
	pack $w.spacer -side right
	
	label $w.status -text "Starting up..."
	pack $w.status -side bottom -fill x -anchor nw
	
	frame $w.f
	pack $w.f -side top -fill both -expand yes
	
	ccsWidgets $w.f
}


# End of init. routine	
