#include <charm++.h>

#ifndef _app_h_
#define _app_h_

class main: public Chare {
 public:
  main(CkArgMsg *m);
  main(CkMigrateMessage *m) {}
};

class SrcArray: public NormalSlabArray {
 public:
  SrcArray(CkMigrateMessage *m) {}
  SrcArray(NormalFFTinfo &i):NormalSlabArray() {
	plane1 = new complex[i.srcSize[0] * i.srcSize[1] * i.srcPlanesPerSlab];
	plane2 = new complex[i.srcSize[0] * i.srcSize[1] * i.srcPlanesPerSlab];
	fftinfos[0] = new NormalFFTinfo(i);
	fftinfos[0]->dataPtr = plane1;
	fftinfos[1] = new NormalFFTinfo(i);
	fftinfos[1]->dataPtr = plane2;
  }

  void doIt(int id) {doFFT(id, id);}
  void doneIFFT(int id) {ckout << id << " Back" << endl;}
 private:
  complex *plane1, *plane2;
};

class DestArray: public NormalSlabArray {
 public:
  DestArray(CkMigrateMessage *m) {}
  DestArray(NormalFFTinfo &i):NormalSlabArray() {
	plane1 = new complex[i.destSize[0] * i.destSize[1] * i.destPlanesPerSlab];
	plane2 = new complex[i.destSize[0] * i.destSize[1] * i.destPlanesPerSlab];
	fftinfos[0] = new NormalFFTinfo(i);
	fftinfos[0]->dataPtr = plane1;
	fftinfos[1] = new NormalFFTinfo(i);
	fftinfos[1]->dataPtr = plane2;
  }
  
  void doneFFT(int id) {ckout << id << " done FFT" << endl; doIt(id);}
  void doIt(int id) {doIFFT(id, id);}
 private:
  complex *plane1, *plane2;
}; 
#endif //_app_h_
