/*
Various collected utilities

Orion Sky Lawlor, olawlor@acm.org, 6/13/2001
*/
#ifndef __CSAR_MESH_UTIL_H
#define __CSAR_MESH_UTIL_H
#include <string>
using std::string;

/************ Simple utilities **************/
//Find the numeric part of the file name, increment it 
// by one and return true.  Returns false if no numbers found
// or field is too short.
bool incrementAscii(char *cur);

//Return true if the indicated file exists and is readable
bool fileExists(const char *fName);

//Return true if a ends in suffix
bool endsWith(const char *a,const char *suffix);

//Replace this string's extention with the given new string
string replaceExtention(const string &a,const string &newSuffix);

//Return the filename, padded for fortran use
// Returns a reference to a static internal buffer 
//  (NOT THREADSAFE)
const char *fortranifyString(const char *src);

#endif
