#include "prime.h"

CProxy_primeMain globalMainProxy;
double start, end;

primeMain::primeMain(CkArgMsg *m)
{
        int lower;
        int upper;
        int nSeg;

        if((m->argc != 4)) {
                CkPrintf("Usage: charmrun +p<nproc> <pgmname> <lower> <upper> <range/node>\n");
                CkExit();
        }
        lower=atoi(m->argv[1]);
        upper=atoi(m->argv[2]);
        nSeg=atoi(m->argv[3]);
        if((lower<=0)||(upper<=1)){
                CkPrintf("There is NO prime in this range!\n");
                CkExit();
        }
        if(lower>upper){
                CkPrintf("Lower limit must be smaller than upper limit!\n");
                CkExit();
        }

        globalMainProxy=thishandle;
	globalMainProxy.ThreadWork(lower,upper,nSeg);
}

void primeMain::ThreadWork(int lower, int upper, int nSeg){
	CkPrintf("With grain size of %d, ", nSeg);

	int nElements;
	CkSemaID primeSema = CkSemaCreate();
	int intRes;
	resultMessage **arrRes;
	start=CkWallTimer();
        limitsMessage *limMsg=new limitsMessage(lower, upper, nSeg, primeSema);
        nElements=(upper-lower+nSeg-1)/nSeg;
	arrRes = new resultMessage * [nElements];
        ap=CProxy_primeArray::ckNew(nElements);
        //ap.setReductionClient(reduceClient,(void *)NULL);
        ap.startWork(limMsg);
	
	CkSemaWaitN(primeSema, nElements, (void **)arrRes);

	double runningtime;
        end=CkWallTimer();
        runningtime=end-start;
	for(int i=0;i<nElements;i++){
		intRes += arrRes[i]->res;
	}
        CkPrintf("I found %d prime(s) in %.6f second(s).\n", intRes, runningtime);
        CkExit();
}

void primeArray::startWork(limitsMessage *limMsg)
{
        int myLower, myUpper, myCount=0;
        myLower=limMsg->lower+limMsg->nSeg*thisIndex;
        myUpper=limMsg->lower+limMsg->nSeg*(thisIndex+1)-1;
        if(myUpper>limMsg->upper){
                myUpper=limMsg->upper;
        }
        if(1==myLower){
                myLower=2;
        }
	if(0==myLower%2) {
                if((myLower==2)&&(myUpper>=2))
                        myCount++;
		myLower++;
        }
        for(int i=myLower;i<=myUpper;i+=2){
                if(isPrime(i))
                        myCount++;
        }
	resultMessage *resMsg = new resultMessage(myCount);
	CkSemaSignal(limMsg->sema, (void *)resMsg);
	//contribute(sizeof(int),(void *)&myCount,CkReduction::sum_int);
}

int isPrime(int x)
{
        int i, prime;
        prime = 1;
        for(i=3; i*i <= x; i+=2) {
                if((x%i) == 0){
                        prime = 0;
                        break;
                }
        }
        return prime;
}

void reduceClient(void *param,int dataSize,void *data)
{
        double runningtime;
        int count=*(int *)data;
        end=CkWallTimer();
        runningtime=end-start;
        CkPrintf("I found %d prime(s) in %.6f second(s).\n", count, runningtime);
        CkExit();
}


