#include <stdio.h>
#include "hello.decl.h"

/*readonly*/ CProxy_Main mainProxy;
/*readonly*/ int nElements;

/*mainchare*/
class Main : public Chare
{
  CProxy_Hello arr;
  int nReduce;
public:
  Main(CkArgMsg* m)
  {
    //Process command-line arguments
    nElements=5;
    if(m->argc >1 ) nElements=atoi(m->argv[1]);
    delete m;

    //Start the computation
    CkPrintf("Running Hello on %d processors for %d elements\n",
	     CkNumPes(),nElements);
    mainProxy = thishandle;

    arr = CProxy_Hello::ckNew(nElements);
    nReduce=0;
    arr.DoContribute(17);
  };

  void done(CkReductionMsg *msg)
  {
    nReduce++;
    delete msg;
    if (nReduce>10*1000) {
      CkPrintf("All done\n");
      CkExit();
    } else {
      if ((nReduce%100)==0)
        CkPrintf("Completed %d reductions...\n",nReduce);
      arr.DoContribute(17);
    }
  };
};

/*array [1D]*/
class Hello : public CBase_Hello 
{
  int n;
  char *arr;
public:
  Hello()
  {
    CkPrintf("Hello %d created\n",thisIndex);
    n=100*1024;
    arr=new char[n];
  }
  ~Hello() {
    delete[] arr;
  }

  Hello(CkMigrateMessage *m) {}

  void DoContribute(int hiNo)
  {
    CkCallback cb(CkIndex_Main::done(0),mainProxy);
    contribute(n,arr,CkReduction::sum_int,cb);
  }
};

#include "hello.def.h"
