#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "charm++.h"
#include "cast.h"
#include "cast.def.h"

main::main(CkArgMsg *m) { 
  t0 = CmiTimer();
  int i;
  for (i=1; i<=5; i++) {
    DataMsg *m = new DataMsg;
    m->x = 1;
    m->y = i;
    CProxy_cast::ckNew(m);
  }
  CkStartQD(EntryIndex(main,allDone,CkQdMsg), &thishandle);
  CkPrintf("main done\n");
};

void main::allDone(CkQdMsg *m) {
  CkPrintf("Quiescence detected. stopping\n");
  CkPrintf("Total time used: %e\n", CmiTimer()-t0);
  CkExit();
};

cast::cast(DataMsg *msg) { 
  x = msg->x;
  y = msg->y;
  CkPrintf("Generating cast (%d, %d).\n", x, y);

  int i=10, j=100;
  double border[100];
  if (1 == x)
    for (int k=0; k<100; k++)
      border[k]=k;
  else
    memcpy(border, msg->b, 100*sizeof(double));

  chunk1(&i, &j, (char **)&data, (double *)&border);

  if (msg->x <= NUM_TIMESTEPS) {
    DataMsg *m = new DataMsg;
    m->x = x+1;
    m->y = y;
    memcpy(m->b, border, 100*sizeof(double));
    CProxy_cast::ckNew(m);
  }

  delete(msg);
};

