#include "Random.h"

Random::Random(){
    Random(1.0, LINEAR);
}

Random::Random(int t){
    Random(1.0, t);
}

Random::Random(double m, int t){
    mean = m;
    type = t;
    seed[0] = random();
    seed[1] = random();
    seed[2] = random();
}

double Random::rand(){

    if(type == LINEAR)  
	return (double)nrand48(seed);
    else if(type == UNIFORM)
	return erand48(seed);
    else if(type == EXPONENTIAL){
	double uniform_val = erand48(seed);
	while(uniform_val == 0.0)
	    uniform_val = erand48(seed);
	return mean * (-log(uniform_val));
    }
}
/*
int main(int argc, char** argv){
    Random *r = new Random(325, EXPONENTIAL);
    Random *l = new Random(LINEAR);
    Random *a = new Random(10,  EXPONENTIAL);

    double mw = 0.0;
    double mp = 0.0;
    double ma = 0.0;

    int count = 1000;
    if(argc > 1)
	count = atoi(argv[1]);

    for(int i = 0; i < count; i++){
	int p = ((int)l->rand())%64 + 1;
	double w =  r->rand();
	double at = a->rand();

	printf("%5.3lf, %d\n", at, p);
	mw += w;
	mp += p;
	ma += at;
    }

    printf("mean = %5.3lf, %5.3lf, %5.3lf\n", mw/count, mp/count, ma/count); 
}
*/
