#include <iostream>
#include <ampi.h>
#include <charm++.h>

int
main(int argc, char** argv)
{
  int *winArea;

  MPI_Init(&argc, &argv);
  int rank = 0;
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);

  MPI_Alloc_mem(sizeof(int), MPI_INFO_NULL, &winArea);
  MPI_Win win;
  MPI_Win_create((void*)winArea, sizeof(int), sizeof(int),
		  MPI_INFO_NULL, MPI_COMM_WORLD, &win);

  if(rank > 0){
    MPI_Win_lock(0, 0, 0, win);
    CkPrintf("[%d] locked window on [%d]\n", rank, 0);
  }
  if(rank > 0){
    MPI_Win_unlock(0,win);
    CkPrintf("[%d] unlocked windown on [%d]\n", rank, 0);
  }

  MPI_Win_free(&win);
  MPI_Free_mem((void*)winArea);
  MPI_Finalize();
  return 0;
}
