/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: 60_get_name.C,v 1.1 2004/01/30 18:26:40 yanshi Exp $
 */
 
 
#include <iostream>
#include <ampi.h>
#include <charm++.h>

int 
main(int argc, char** argv) 
{ 
  int size, rank; 
  int *winArea; 
  MPI_Win win;
  char winname[] = "Win_Name";
  char getname[100];
  int resultlen;

  MPI_Init(&argc, &argv); 
 
  MPI_Comm_size(MPI_COMM_WORLD, &size); 
  MPI_Comm_rank(MPI_COMM_WORLD, &rank); 
 
  MPI_Alloc_mem(sizeof(int), MPI_INFO_NULL, &winArea);
  
  MPI_Win_create(winArea, sizeof(int), sizeof(int), 
		 MPI_INFO_NULL, MPI_COMM_WORLD, &win); 
 
  *winArea = rank; 
  
  /* 
   * Set and get window name and compare the two to see if the value is same
   * as we put in. Else abort.
   */  

  MPI_Win_set_name(win, winname);
  MPI_Win_get_name(win, getname, &resultlen);
  if (strcmp(winname, getname) != 0)
      CkPrintf("Win::Get_name obtained value \"%s\", expected \"%s\"\n",
	       getname, winname);

  MPI_Win_free(&win);
  MPI_Free_mem(winArea); 
  MPI_Finalize(); 
  return(0); 
}
