/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: 70_accumulate.C,v 1.1 2004/01/30 18:26:40 yanshi Exp $
 *
 * Basic fence test.  Mainly contributed by some LAM user(sorry; I've
 * long since lost the name of the original author!).  Somewhat
 * modified to be suitable for the LAM test suite.
 */

#include <iostream>
#include <ampi.h>
#include <charm++.h>

int
main(int argc, char** argv)
{
  int SendBuff=0, RecvBuff=0, expected=0, i;
  int rank, size;
  MPI_Init(&argc, &argv);
  
  
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);
  MPI_Comm_size(MPI_COMM_WORLD, &size);

  //MPI_Type_extent(MPI_INT, &sizeOfInt);
  MPI_Win Win;
  MPI_Win_create(&RecvBuff, sizeof(int), 1, 0,
		  MPI_COMM_WORLD, &Win);
  CkPrintf("[%d] created window(%p) {%d}, base *[%p]\n", rank, &Win, Win, &RecvBuff);
  SendBuff = rank + 100;
  RecvBuff = 0;

  /* 
   * Pretty simple test -- just call MPI::Win::Create
   */  

  MPI_Win_fence(0, Win);
  for (i = 0; i < size; ++i)
    MPI_Accumulate(&SendBuff, 1, MPI_INT, i, 0, 1, MPI_INT, MPI_SUM, Win);

  MPI_Win_fence(0, Win);

  for (expected = i = 0; i < size; i++)
    expected += (i + 100);
  
  //if (RecvBuff != expected)
    CkPrintf("Rank %d got %d when it expected %d\n",
		 rank, RecvBuff, expected);
  
  MPI_Win_free(&Win);
  
  MPI_Finalize();
  return 0;
}

