/*
Rather hideous main routine:
	-Reads particles in chunks from the 'particles' xdr file
	-Sends particles to "Data" array elements, waiting for quiencense
to keep from overflowing our output network buffers.
	-Waits for requests from clients, which come in via "getGrid"
	-Assembles a return image, which it sends out via "sendGrid"

This is a bad example in several ways:
	-The reading is serialized at the main routine rather than
being fully distributed.  This contorts the design and provides a 
large bottleneck.

Orion Sky Lawlor, olawlor@acm.org, Summer of 2001
*/

#include <math.h>
#include "liveViz.h"
#include "xdrReader.h"
typedef CkBbox3d bbox3d;
#include "analyse.decl.h"
PUPbytes(bbox3d);

#define MAXDIM 3

/*This is the number of points to read at once.
Each darkParticle is about 100 bytes, so bunch==10000
means to read about 1 meg at a time.
*/
#define BUNCH 10000  
#define MAXINTENSITY 255
#define INTENSITY_SCALE 255

CProxy_Main mainProxy;
CProxy_PointSet dataProxy;

class Main: public Chare {
public:
  FILE * fd;
  int responders,nResponders;
  int totalCount; //Total number of points
  bbox3d box;//World bounding box

  Main(CkArgMsg *m) {
    ckout << "in main\n" << endl;
    nResponders=CkNumPes();
    dataProxy = CProxy_PointSet::ckNew(nResponders);
    responders = 0;
    totalCount=0;
    box.empty();
    mainProxy = thishandle;
    fd = fopen("particles", "r");
    
    if (fd ==0) CkAbort("Could not open 'particles' file. \n"
	"This 47-meg file can be downloaded from:\n"
	"    http://charm.cs.uiuc.edu/2002/astro/particles\n"
	"You may be able to just use the command:\n"
	"    wget  http://charm.cs.uiuc.edu/2002/astro/particles\n");
    
    xdrReaderInit(fd);
    sendPoints();
  }

  //Send a round of data off to each array element:  
  void sendPoints(void) {
    ckout << "Reading data..." << endl;
    for (int r=0;r<nResponders;r++) { 
      darkParticle A[BUNCH];
      int size = xdrReaderRead(A, BUNCH);
      if (size==0) { //Done with input file-- get count
        responders=0;
        dataProxy.countRequest();
	return;
      }
      dataProxy[r].recvPoints(size, A);
    }

    //Once we hit quiescence, call sendData again  
    int ep = CkIndex_Main::sendPoints();
    CkStartQD(ep, &thishandle);
  }
  
  //A client reports his bounding box here:
  void counts(int count,const bbox3d &b) {
    totalCount += count;
    box.add(b.min); box.add(b.max);
    if (++responders == nResponders) 
    { //We now have everybody's bounding box
      ckout << "total particles: " << totalCount << endl;
      for (int i=0; i<MAXDIM; i++) 
	ckout << " bounding box "<<i<<": "
		<< box.max[i] << " to " << box.min[i] << endl;
      
      //Use the bounding box to start liveViz:
      liveVizConfig cfg(false,false,box);
      //cfg.moreVerbose(); cfg.moreVerbose();
      liveVizInit(cfg,dataProxy,CkCallback(CkIndex_PointSet::getImage(0),dataProxy));
    }
  }
};

class PointSet: public ArrayElement1D {
public:
  enum {maxParticles=4194304/2 };
  darkParticle particles[maxParticles];
  int nParticles;
  
  PointSet(CkMigrateMessage * m) {};
  PointSet() {
    nParticles = 0;
  }

  void recvPoints(int n, darkParticle * A) {
    for (int i = 0; i<n; i++) 
      particles[nParticles++]=A[i];
    if (nParticles > maxParticles) {
      ckout << "array overflow on:" << thisIndex << endl;
      CkExit();
    }
  }

  void countRequest(void) {
    bbox3d box;
    box.empty();
    for (int i=0; i<nParticles;  i++)
      box.add(particles[i].pos);
    ckout << thisIndex << ": sending counts: " << nParticles << endl;
    mainProxy.counts(nParticles, box);
  }

  void getImage(liveVizRequestMsg *m)
  {

    const liveVizRequest3d &req=m->req;
#if 0
    ckout << "image request arrived on " << thisIndex << " size: " <<
    	req.wid << "x" <<req.ht << endl;
#endif

    { // non-orthogonal section. Use x, y, z vectors and origin
      int Zclip = 0;
      int XYclip = 0;
      int Bclip = 0;
      int rowBytes=req.wid;
      int imgLen=rowBytes*req.ht;
      byte *img=new byte[imgLen];
      int i;
      //Zero out image:
      for (i=0; i<imgLen; i++) img[i] = 0;

      //Plot each particle
      for (i=0; i<nParticles;  i++) {
      	CkVector3d p=particles[i].pos-req.o;
      	float z = p.dot(req.z);
	if ((z <req.minZ) || (z > req.maxZ)) {Zclip++; continue;}
	int x = (int) p.dot(req.x);
	int y = (int) p.dot(req.y);
	if ( ( (x>=req.wid) || (y>=req.ht)) || 
	       ( (x<0) || (y<0)) ) { XYclip++; continue; }
	const int bright=1;
	byte &cur=img[rowBytes*y+x];
	int sum=cur+bright;
	if (1 && sum>MAXINTENSITY) {
	  Bclip++;
	  sum=MAXINTENSITY;
	}
	cur=sum;
      }

#if 0
      ckout <<thisIndex<< "("<<req.wid<<","<<req.ht<<") image.  Z Clip: "<<Zclip 
          <<" XY Clip: "<<XYclip  <<" Bright clip: "<<Bclip  <<" Nparticles="<<nParticles <<endl; 
#endif
      //Send the image off to liveViz:
      liveVizDeposit(m,0,0,req.wid,req.ht,img,this);
      delete[] img;
    }
  }
};


#include "analyse.def.h"
