/*
  Data structures for XDR I/O
*/
#ifndef __UIUC_CHARM_ASTRO_H
#define __UIUC_CHARM_ASTRO_H

#include "ckvector3d.h"

typedef CkVector3dT<float> CkVector3f;

struct dark_particle {
public:
    float mass;
    CkVector3f pos;
    CkVector3f vel;
    float eps;
    float phi;
};
typedef dark_particle darkParticle;

int xdrReaderInit(FILE *fd);
int xdrReaderRead(dark_particle *A, int max);
void xdrReaderDone();

#endif
