#include <math.h>
#include <liveViz.h>
#include "app.decl.h"

CProxy_appArray a;

class app: public Chare {
public:
  app(CkArgMsg *m) {
    int nElements=15;
    if (m->argc>1) nElements=atoi(m->argv[1]);

    CkArrayOptions opts(nElements);
    liveVizConfig cfg(true, false);
    cfg.moreVerbose(); cfg.moreVerbose();
    liveVizPollInit(cfg, opts);
    a = CProxy_appArray::ckNew(opts);

    a.requestNextFrame();
  }
};

class appArray: public ArrayElement1D {
  double timestep;
public: 
  appArray(CkMigrateMessage * m) {};
  appArray() {timestep=0.0;}

  void requestNextFrame() {
    timestep+=0.001;
    liveVizPollRequestMsg *m;
    
    while ( NULL!= (m=liveVizPoll(this,timestep))) {
      int sx=-3+10*thisIndex,sy=32; // Topleft corner of my part of the image
      int w=8,h=32; // Size of my part of the image
      unsigned char *intensity=new unsigned char[3*w*h];
      for (int y=0;y<h;y++)
      for (int x=0;x<w;x++) {
    	  int i=y*w+x;
    	  intensity[3*i+0] = (byte) (244-10*thisIndex);//Red
    	  intensity[3*i+1] = (byte) (0+20*thisIndex);//Green
    	  intensity[3*i+2] = (byte) (128);//Blue
      }
      liveVizPollDeposit((ArrayElement *)this, timestep, m->req, sx,sy, w,h, intensity);
      delete[] intensity;
      delete m;
    }

    usleep(1000);

    a(thisIndex).requestNextFrame();
  }
};

#include "app.def.h"

