#include <math.h>
#include "liveViz.h"
#include "app.decl.h"

CkArrayID a;

class app: public Chare {
public:
  app(CkArgMsg *m) {
    int nElements=15;
    if (m->argc>1) nElements=atoi(m->argv[1]);
    CProxy_app thisproxy(thishandle);
    a = CProxy_appArray::ckNew(nElements);
    CkCallback c(CkIndex_appArray::requestNextFrame(0),a);
    liveVizConfig cfg(true,false);
    cfg.moreVerbose(); cfg.moreVerbose();
    liveVizInit(cfg,a,c);
  }
};

class appArray: public ArrayElement1D {
public: 
  appArray(CkMigrateMessage * m) {};
  appArray() {}

  void requestNextFrame(liveVizRequestMsg *m) {
    int sx=-3+10*thisIndex,sy=32; // Topleft corner of my part of the image
    int w=8,h=32; // Size of my part of the image
    unsigned char *intensity=new unsigned char[3*w*h];
    for (int y=0;y<h;y++)
    for (int x=0;x<w;x++) {
    	int i=y*w+x;
    	intensity[3*i+0] = (byte) (244-10*thisIndex);//Red
    	intensity[3*i+1] = (byte) (0+20*thisIndex);//Green
    	intensity[3*i+2] = (byte) (128);//Blue
    }
    liveVizDeposit(m, sx,sy, w,h, intensity, this);
    delete[] intensity;
  }
};

#include "app.def.h"

