#include <stdio.h>
#include "hello.decl.h"

/*readonly*/ CProxy_Main mainProxy;
/*readonly*/ int nElements;

int nLoops=100;
#define nDoublePer 100000
double tStart;

/*mainchare*/
class Main : public Chare
{
public:
  Main(CkArgMsg* m)
  {
    //Process command-line arguments
    nElements=5;
    if(m->argc >1 ) nElements=atoi(m->argv[1]);
    delete m;

    //Start the computation
    CkPrintf("Running Hello on %d processors for %d elements\n",
	     CkNumPes(),nElements);
    mainProxy = thishandle;

    CProxy_Jacobi arr = CProxy_Jacobi::ckNew(nElements);

    arr.start();
    tStart=CkWallTimer();
  };

  void done(void)
  {
    double elapsed=CkWallTimer()-tStart;
    CkPrintf("All done: %.3f MFlops\n", 
    	3*1.0e-6*nLoops*nDoublePer*nElements/elapsed);
    CkExit();
  };
};

/* Serial Jacobi calculation class: */
class JacobiChunk {
public:
	enum {N=nDoublePer}; // Number of interior points we store
private:
	enum {ghost=1}; // Number of ghosts on either side
	
	double data[ghost+N+ghost];	
public:
	// Initialize the interior of our chunk:
	JacobiChunk() {
		for (int i=ghost;i<ghost+N;i++) data[i]=0.0;
	}
	
	// Initialize one of the boundaries of our chunk:
	void setBoundary(int side,double val) {
		if (side==0) data[0]=val;
		if (side==1) data[ghost+N]=val;
	}
	
	// Provide access to our interior points:
	inline double &operator[](int i) {return data[ghost+i];}
	inline double operator[](int i) const {return data[ghost+i];}
};

// Smooth out the interior of this JacobiChunk
//  based on its boundaries:
void smooth(JacobiChunk src,JacobiChunk &dest) {
	for (int i=0;i<JacobiChunk::N;i++) {
		double neighbors=(src[i+1]+src[i]+src[i-1])/3;
		dest[i]=neighbors;
	}
}

/*array [1D]*/
class Jacobi : public CBase_Jacobi
{
  int curStep, nSteps;
  int curBorder, nBorders;
  JacobiChunk chunk;
public:
  Jacobi()
  {
    curStep=0;
    nSteps=100;
    curBorder=0;
    nBorders=0;
    if (thisIndex-1>0) nBorders++;
    if (thisIndex+1<nElements) nBorders++;
    
    // Set our left and right boundaries
    chunk.setBoundary(0,0.0);
    chunk.setBoundary(1,1.0);
  }
  Jacobi(CkMigrateMessage *m) {}
  void compute(void);
  
  // Begin a jacobi sweep:
  void start(void) {
    curStep++;
// CkPrintf("[%d] Start step %d\n",thisIndex,curStep);
    if (curStep>=nSteps) mainProxy.done();
    
    if (thisIndex-1>0) // We have a left neighbor:
      thisProxy[thisIndex-1].borders(curStep,1,chunk[0]);
    
    if (thisIndex+1<nElements) // We have a right neighbor:
      thisProxy[thisIndex+1].borders(curStep,0,chunk[JacobiChunk::N-1]);
  }
  
  void borders(int step,int side,double val) {
// CkPrintf("[%d] Recv step %d: step %d side %d val %f\n",thisIndex,curStep,step,side,val);
    // FIXME: if step>curStep, buffer the border update
    chunk.setBoundary(side,val);
    
    curBorder++;
    if (curBorder>=nBorders) 
    { // We have all our borders:
// CkPrintf("[%d] Computing for step %d\n",thisIndex,curStep);
      curBorder=0;
      
      compute();
      
      thisProxy[thisIndex].start();
    }
  }
};

void Jacobi::compute(void) {
  JacobiChunk oldChunk=chunk;
  smooth(oldChunk,chunk);
}

#include "hello.def.h"
