#include <iostream.h>
#include <taskGraph.h>
#include "fib.decl.h"

CkChareID mainhandle;

class fibSolver : public taskGraphSolver {
  protected:
    int value;
  public:
    fibSolver(CkArrayID id, int idx, int tmp = -1)
      : taskGraphSolver(id, idx) { value = tmp; };
    fibSolver(CkMigrateMessage *m) : taskGraphSolver(m) {};


    virtual void pup(PUP::er &p) {
      p|value;
    }
    PUPable_decl(fibSolver);

    virtual void solve(int depsCount, taskGraphSolver *data[]) {
      value = 0;
      fibSolver **myData = (fibSolver **)data;

      for ( int i = 0 ; i < depsCount ; i++ ) {
        value += myData[i]->value;
      }

      CProxy_main main(mainhandle);
      main.results(value);
    }

    virtual void setup() {
      CProxy_main main(mainhandle);
      main.results(value);
    }
};

class main : public Chare {
  protected:
    int pending;

  public:
    main(CkArgMsg *m) {
      mainhandle = thishandle;
      pending = 0;
      CkArrayID worker = fibSolver::newTaskGraph();

      fibSolver base0(worker, 0, 0),
                base1(worker, 1, 1);
      base0.startTask(); base1.startTask();
      pending++; pending++;

      if ( m->argc != 2 ) {
        ckerr << "Usage: " << m->argv[0] << " <number to find>" << endl;
	CkExit();
	return;
      }

      for ( int i = 2 ; i < atoi(m->argv[1]) ; i++ ) {
	fibSolver next(worker, i);
	next.dependsOn(i-1);
	next.dependsOn(i-2);
	next.startTask();
	pending++;
      }
    }

    void results(int value) {
      ckerr << "main::results " << value << endl;
      pending--;

      if ( pending == 0 ) {
	CkExit();
      }
    }
};

#include "fib.def.h"
