#include <stdio.h>
#include "hello.decl.h"

CProxy_main mainProxy;
CProxy_Hello arr;

/* Sizes of memory to allocate/deallocate */
int nSizes=7;
const static int sizes[]={10,100,1000,10000,100000,1000000,10000000};

extern "C" {
	typedef void *(*malloc_fn)(int size);
	typedef void (*free_fn)(void *ptr);
};

extern "C" void *call_CkAllocMsg(int size) {
	return CkAllocMsg(-1,size,0);
}
extern "C" void *call_new(int size) {
	return new char[size];
}
extern "C" void call_delete(void *ptr) {
	char *c=(char *)ptr;
	delete[] c;
}

int allocInner(malloc_fn m,free_fn f,int nTimes,int size) 
{
	int ret=0; /* prevents compiler from optimizing away loops */
	for (int t=0;t<nTimes;t++) {
		int is=size/sizeof(int);
		int i;
		int *c=(int *)m(size);
		// Write a bunch of data into the buffer
		for (i=0;i<is;i++) c[i]=ret;
		// Read a bunch of data back out of the buffer
		for (i=0;i<is;i++) ret+=c[i];
		f(c);
	}
	return ret;
}


void allocTimeTest(malloc_fn m,free_fn f,const char *desc)
{
	for (int sc=0;sc<nSizes;sc++) {
		int s=sizes[sc];
		
		double startTime=CmiWallTimer();
		// Figure out how many times to run loop:
		int n=1; 
		while (CmiWallTimer()<0.01+startTime) {
			allocInner(m,f,n,s);
			n*=2;
		}
		// Do a single, final loop for the real time:
		startTime=CmiWallTimer();
		allocInner(m,f,n,s);
		double elapsed=(CmiWallTimer()-startTime)/n;
		printf("%s  %8d bytes:   %.2f us    %.2f ns/byte\n",
			desc,s, 1.0e6*elapsed, 1.0e9*elapsed/s);
	}
	printf("\n");
}

class main : public Chare
{
public:
  main(CkMigrateMessage *m) {}
  main(CkArgMsg* m)
  {
    allocTimeTest((malloc_fn)malloc,(free_fn)free,"malloc/free");
    if (m->argc>1) /* must have "verbose" argument */ {
      allocTimeTest(CmiAlloc,CmiFree,"CmiAlloc/CmiFree");
      allocTimeTest(call_CkAllocMsg,CkFreeMsg,"CkAllocMsg/CkFreeMsg");
      allocTimeTest(call_new,call_delete,"C++ new/delete");
    }
    CkExit();
  }
  void done(void)
  {
  }
};

class Hello : public ArrayElement1D
{
public:
  Hello() {}

  Hello(CkMigrateMessage *m) {}
  void run(void)
  {}
};

#include "hello.def.h"
