/*
  Demonstration of how to use Charm++ checkpointing
  in the context of a (fairly) real Charm program.
 */
#include <stdio.h>
#include "hello.decl.h"

/*readonly*/ CProxy_Main mainProxy;
/*readonly*/ int nElements;

/*mainchare*/
class Main : public Chare
{
public:
  Main(CkArgMsg* m)
  {
    //Process command-line arguments
    nElements=5;
    if(m->argc >1 ) nElements=atoi(m->argv[1]);
    delete m;

    //Start the computation
    CkPrintf("Running Hello on %d processors for %d elements\n",
	     CkNumPes(),nElements);
    mainProxy = thishandle;

    CProxy_Hello arr = CProxy_Hello::ckNew(nElements);

    arr[1].SayHi(17);
  };

  void done(void)
  {
    CkPrintf("All done\n");
    CkExit();
  };
};

/*array [1D]*/
class Hello : public CBase_Hello 
{
  int count;
public:
  Hello()
  {
    CkPrintf("Hello %d created\n",thisIndex);
    count=0;
  }

  Hello(CkMigrateMessage *m) {
    CkPrintf("Hello %d migrated in\n",thisIndex);
  }
  void pup(PUP::er &p) {
    CBase_Hello::pup(p);
    p|count;
  }
  void backFromCheckpoint(void) 
  { //Continue passing SayHi around ring:
    CkPrintf("backFromCheckpoint:\n");
    thisProxy[thisIndex+1].SayHi(1001);
  }
  void SayHi(int hiNo)
  {
    count++;
    CkPrintf("Hi[%d] from element %d\n",hiNo,thisIndex);
    if (thisIndex != 0)
      //Pass the hello on:
      thisProxy[(thisIndex+1)%nElements].SayHi(hiNo+1);
    else /*I'm element zero: */ 
    {
      if (count<2) { //Checkpoint:
        CkCallback cb(CkIndex_Hello::backFromCheckpoint(),thisProxy[thisIndex]);
        CkStartCheckpoint("checkpointData",cb);
      } else {
      //We've been around once-- we're done.
        CkPrintf("All done\n");
        CkExit();
      }
    }
  }
};

#include "hello.def.h"
