#include "BasicStrategy.h"

BasicStrategy::BasicStrategy(int nodes){
    this->num_nodes = nodes;
}

int BasicStrategy::get_optimal_allocation(Job *j, Job *runq){
  
    //    printf("In get opt allocation\n");

    Job *jptr = runq;
    // Number of CPU's in use by migratable jobs.
    int n_migrate_nodes = 0;
    // Minimum number needed by migratable jobs.
    int min_used_nodes = 0;
    int n_migrate_jobs = 0;
    int opt_alloc = 0;
    int max_alloc = 0;

    //    printf("in get_optimal_allocation\n");

    // Otherwise, let's find out the lower bound on number of used CPU's.
    while(jptr != NULL){
	if(jptr->type == MCHARM){
	    min_used_nodes += jptr->min_nodes;
	    n_migrate_nodes += jptr->num_allocated_nodes;
	    n_migrate_jobs ++;
	}
	/*
	else if(jptr->type == MPI)
	    min_used_nodes += jptr->num_allocated_nodes;
	else // Non Migratable Charm Job
	    min_used_nodes += jptr->num_allocated_nodes;
	*/
	jptr = jptr->next;
    }

    //All those that can be migrated and the ones in the freelist.
    //Note it is not num_nodes - min_used_nodes as some may have been used in 
    //the previous waitq entries.
    max_alloc = n_migrate_nodes - min_used_nodes + num_free_nodes;
    opt_alloc = (n_migrate_nodes + num_free_nodes) / (n_migrate_jobs + 1);

    if(opt_alloc > max_alloc)
        opt_alloc = max_alloc;
    
    if(opt_alloc > j->max_nodes)
	opt_alloc = j->max_nodes;

    // Can we make available enough CPU's for this job ?
    if((opt_alloc < j->min_nodes) && (j->min_nodes <= max_alloc))
	opt_alloc = j->min_nodes;

    if(opt_alloc == 1){
        //        printf("WARNING DANGER max_alloc = %d, num free nodes = %d\n", max_alloc, num_free_nodes);
	jptr = runq;
	while (jptr != NULL){
            //	    printf("#allocated nodes = %d\n", jptr->num_allocated_nodes);
	    jptr = jptr->next;
	}
    }

    //    printf("After get opt allocation\n");

    return opt_alloc;
}

// returns -1 for failure, 1 for success.
// can we accept this job ?
int BasicStrategy::is_available(Job *j, Job *waitq, Job *runq){
    
    Job *jptr = runq;

    int opt_alloc = get_optimal_allocation(j, runq);

    //    printf("opt_alloc = %d, minpe = %d\n", opt_alloc, j->min_nodes);    
    if(opt_alloc >= j->min_nodes)
	return 1;

    else return -1;
}

void BasicStrategy::opt_allocate(Job *j, Job *runq, int nalloc){
    
    Job *jptr = runq;
    int temp_nodes = 0;
    int num_allocated = 0;

    //    printf("In opt_allocate \n");

    // First, let's give the job the free CPU's, if any are available.
    if(num_free_nodes > 0){
	for(int i=0; i < num_nodes; i++)
	    if((num_allocated < j->max_nodes) && free_node_vector[i]){
		j->add_node(i);
		free_node_vector[i] = 0;
		num_free_nodes --;
		num_allocated++;
	    }
        //	printf("########  num_allocated = %d, %d %d\n", j->num_allocated_nodes, j->max_nodes, num_free_nodes);
	if(num_allocated == j->max_nodes)
	    return;
    }

    // If the job still needs CPU's, let's reallocate them away from
    // the migratable jobs.
    //
    // The outermost loop is because we might have to go through the
    // Job List several times.  We are trying to be fair by taking
    // away only one CPU from each running job during each iteration.
    while(num_allocated < j->min_nodes){
        // Let's go through the list of jobs.
	jptr = runq;
	while((jptr != NULL) && (num_allocated < j->min_nodes)){
           // Let's find a migratable job with potentially available
           // CPU's.  We'll reallocate only one CPU for now.
	    if((jptr->type == MCHARM) &&
	       (jptr->num_allocated_nodes > jptr->min_nodes)){
		temp_nodes = jptr->delete_node();
		j->add_node(temp_nodes);
		num_allocated++;
	    }
	    jptr = jptr->next;
	}
    }

    // We've given the new job its min CPU's.  To be fair, we'll now
    // try and give it the average number of CPU's given to migratable
    // jobs.  We'll take away CPU's from migratable jobs which have
    // more CPU's than we do, without breaking their MIN CPU
    // constraint, of course.
    int alloc_flag = 0;
    int itr = 0;
    while(num_allocated < nalloc){
	
	if(jptr == NULL)
	    jptr = runq;
	while((jptr != NULL) && (num_allocated < nalloc)){
	    if((jptr->type == MCHARM) &&
	       (jptr->num_allocated_nodes > jptr->min_nodes)
	       &&(jptr->num_allocated_nodes > j->num_allocated_nodes + 1)){
		temp_nodes = jptr->delete_node();
		j->add_node(temp_nodes);
		num_allocated++;
		alloc_flag = 1;
	    }
	    jptr = jptr->next;
	}
	if((!alloc_flag) && (itr > 0))
	    break;
	alloc_flag = 0;
	jptr = runq;
	itr ++;
    }
}

// This function does the bulk of the work in allocating CPU's to a
// new job.  Although this function calculates the new bitmap for
// every migratable job, it does not tell the job to update itself.
void BasicStrategy::allocate_nodes(Job *waitq, Job * runq){

    Job *jptr = waitq;
    int opt_alloc;

    //    printf("In allocate Nodes %d\n", runq);

    while(jptr != NULL){
	opt_alloc = get_optimal_allocation(jptr, runq);
    
        //        printf("opt_alloc = %d\n", opt_alloc);
	if(opt_alloc >= jptr->min_nodes)
	    opt_allocate(jptr, runq, opt_alloc);

	jptr = jptr->next;
    }	
    
    if(runq)
	expand_running_jobs(runq);

    //    printf("After allocate nodes\n");

    return;
}

void BasicStrategy::expand_running_jobs(Job *runq){
    Job *jptr;
    int status;

    //    printf("In expand running jobs\n");

    if(num_free_nodes == 0)
	return;

    jptr = runq;
    while((jptr != NULL) && ((jptr->type != MCHARM)
			     || (jptr->num_allocated_nodes == jptr->max_nodes))) 
	jptr = jptr->next;

    if(jptr == NULL)
	return;

    int min_pes = jptr->num_allocated_nodes;
    Job * min_nodes_job = jptr;
    Job * startptr = jptr;

    for(int i=0; i<num_nodes; i++){
	if(!free_node_vector[i])
	    continue;
	while(jptr != NULL){
	    if((jptr->type == MCHARM) && (jptr->num_allocated_nodes < min_pes)
	       && (jptr->num_allocated_nodes < jptr->max_nodes)){
		min_nodes_job = jptr;
		min_pes = jptr->num_allocated_nodes;
	    }
	    jptr = jptr->next;
	}

	if(min_nodes_job == NULL)
	    break;
	//printf("adding node %d to %d\n", i, min_nodes_job->dbid);
	min_nodes_job->add_node(i);
	free_node_vector[i] = 0;
	num_free_nodes --;
	min_pes = num_nodes + 1;
	min_nodes_job = NULL;
	jptr = startptr;
    }
}
