#ifndef COMMON_H
#define COMMON_H

#include <pthread.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/wait.h>
#include <sys/types.h>

#include <sys/socket.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <semaphore.h>
#include <netdb.h>
#include <signal.h>
#include <strings.h>

#include <iostream.h>

#define MAX_CONN 256
#define LARGE_BUF_SIZE 16384
#define SMALL_BUF_SIZE 1024
#define VERY_SMALL_BUF_SIZE 64
#define MAX_SYSTEM_NODES 256

#define MCHARM  0        // migratable charm jobs, started on all processors.
#define MPI     1        // MPI jobs.
#define NCHARM  2        // Non migratable charm jobs, default.
#define UNI     3        // Uni processor jobs.

#define QUEUED    0
#define RUNNING   1
#define FAILED_CONNECT 2
#define CONNECTED 3
#define SUSPENDED 6
#define FINISHED  4
//#define BITMAPSET 5

//Job Flags
#define DEBUG_ON 1
#define NOTIFY_START 2
#define NOTIFY_END   4
#define CCS_ON       8

#define MAGIC_KEY "1266270673077512018"
//use smarter security mechanism

extern "C"{
#include "ccs-client.h"
}

#define MPIRUN "/usr/local/bin/mpirun"
//#define RSH    "/usr/local/bin/ssh"
#define RSH    "/usr/bin/rsh"

struct job_net_stats{
    unsigned int port,ip,pid;
};

class Job{
 public:  

    unsigned int port,ip,pid;
    int client_soc_fd;

    int type; // priority;
    int min_nodes, min_pe;
    int max_nodes, max_pe;
    int num_system_nodes;
    int num_allocated_nodes;
    int kill_node_jobs;    //If node jobs have to be explicitly killed.

    int ppn, max_ppn;

    CcsServer svr;
    
    char ** argv;
    char argbuf[LARGE_BUF_SIZE];
    char bit_map[MAX_SYSTEM_NODES];
    char userName[SMALL_BUF_SIZE];

    char working_directory[SMALL_BUF_SIZE];
    char Stdin[SMALL_BUF_SIZE], Stdout[SMALL_BUF_SIZE], Stderr[SMALL_BUF_SIZE];
    int dbid;
    char script_name[SMALL_BUF_SIZE]; 
    char name[SMALL_BUF_SIZE];
    char nodes_file[SMALL_BUF_SIZE];
    char num_proc_string[VERY_SMALL_BUF_SIZE];
    char email[SMALL_BUF_SIZE];
    char display[SMALL_BUF_SIZE];

    int status;
    int bitmap_changed;
    
    int allocated_time;
    int start_time;

    int flags;

    Job *next;
    
    Job(int nodes, int ppn);
    ~Job();
 
    void* operator new(size_t s);
    void operator delete(void *p, size_t s);

    int parse_query(char *query);
    void init_arg();
    void re_init();

    int connect();
    static int ping(int jpid);
    void Kill();
    int set_bitmap();    
    
    void add_node(int n);
    int delete_node();
    int delete_all(char *bit_map);

    void started();
    void send_email(const char *, int state);
};

/* The strategy does not distinguish between nodes and processors, so
   we will use proc to represent entities (either nodes or processors)
   which need to be allocated to jobs */

class SchedulingStrategy{
 public:
    virtual int is_available(Job *j, Job *waitq, Job *runq) = 0;
    virtual void allocate_nodes(Job *waitq, Job *runq) = 0;
    
    char *free_node_vector;
    int num_free_nodes;
    int num_nodes;
};

double getCurrentTime();

class CcsException {
    int code;
    char errorMessage[SMALL_BUF_SIZE];
 public:
    CcsException(int code, const char *msg);
    void getMessage(char *buf);
};

#endif
