#include <iostream>
#include <ampi.h>
#include <charm++.h>

int
main(int argc, char** argv)
{
  int *winArea;

  MPI_Init(&argc, &argv);
  int rank = 0;
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);

  MPI_Alloc_mem(sizeof(int), MPI_INFO_NULL, &winArea);
  CkPrintf("[%d] MPI_Alloc_mem \n", rank);

  MPI_Win win;
  MPI_Win_create((void*)winArea, sizeof(int), sizeof(int),
		  MPI_INFO_NULL, MPI_COMM_WORLD, &win);
  CkPrintf("[%d] MPI_Win_create\n", rank);

  MPI_Win_free(&win);
  CkPrintf("[%d] MP_Win_free\n", rank);
  
  MPI_Free_mem((void*)winArea);
  CkPrintf("[%d} MPI_Free_mem\n", rank);
  MPI_Finalize();
  return 0;
}
