/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import projections.gui.Analysis;
import projections.gui.AnimationColorBarPanel;
import projections.gui.AnimationDisplayPanel;
import projections.gui.IntervalRangeDialog;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.ProjectionsWindow;
import projections.gui.SwingWorker;
import projections.gui.TimeTextField;
import projections.gui.U;
import projections.gui.Util;

public class AnimationWindow
extends ProjectionsWindow
implements ActionListener {
    private AnimationColorBarPanel colorbarPanel;
    private AnimationDisplayPanel displayPanel;
    private AnimationWindow thisWindow;
    private Button bPlusOne;
    private Button bMinusOne;
    private Button bAuto;
    private Button setRanges;
    private TimeTextField delayField;
    private Panel statusPanel;
    private Panel titlePanel;
    private Label lTitle;
    private Label lStatus;
    private Label lDelay;
    private int redrawDelay;
    private int curInterval = 0;
    private boolean keepAnimating;
    private AnimateThread thread;
    private boolean layoutComplete = false;
    public long intervalSize;
    public OrderedIntList validPEs;
    public long startTime;
    public long endTime;

    public AnimationWindow(MainWindow mainWindow, Integer n) {
        super(mainWindow, n);
        this.setBackground(Analysis.background);
        this.setTitle("Animation");
        this.createMenus();
        this.thisWindow = this;
        this.showDialog();
    }

    public void showWindow() {
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new IntervalRangeDialog(this, "Select Animation Range");
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    if (AnimationWindow.this.thisWindow.layoutComplete) {
                        if (AnimationWindow.this.dialog.isModified()) {
                            AnimationWindow.this.displayPanel.setParameters();
                        }
                    } else {
                        AnimationWindow.this.createLayout();
                    }
                    return null;
                }

                public void finished() {
                    if (AnimationWindow.this.thisWindow.layoutComplete) {
                        AnimationWindow.this.pack();
                        AnimationWindow.this.thisWindow.setVisible(true);
                    } else {
                        AnimationWindow.this.thisWindow.repaint();
                    }
                }
            };
            swingWorker.start();
        }
    }

    public void getDialogData() {
        IntervalRangeDialog intervalRangeDialog = (IntervalRangeDialog)this.dialog;
        this.intervalSize = intervalRangeDialog.getIntervalSize();
        this.validPEs = intervalRangeDialog.getValidProcessors();
        this.startTime = intervalRangeDialog.getStartTime();
        this.endTime = intervalRangeDialog.getEndTime();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.delayField) {
            this.redrawDelay = (int)(this.delayField.getValue() / 1000L);
        } else if (actionEvent.getSource() instanceof Button) {
            Button button = (Button)actionEvent.getSource();
            if (button == this.bPlusOne) {
                this.changeCurI(this.displayPanel.getCurI() + 1);
            } else if (button == this.bMinusOne) {
                this.changeCurI(this.displayPanel.getCurI() - 1);
            } else if (button == this.bAuto) {
                if (button.getLabel().equals("Auto")) {
                    button.setLabel("Stop");
                    this.keepAnimating = true;
                    this.thread = new AnimateThread();
                    this.thread.start();
                } else {
                    button.setLabel("Auto");
                    if (this.thread != null && this.thread.isAlive()) {
                        this.keepAnimating = false;
                        this.thread = null;
                        this.changeCurI(this.displayPanel.getCurI());
                    }
                }
            } else if (button == this.setRanges) {
                this.showDialog();
            }
        }
    }

    private void changeCurI(int n) {
        this.displayPanel.setCurI(n);
        this.setTitleInfo(this.displayPanel.getCurI());
    }

    private void createLayout() {
        Panel panel = new Panel();
        this.titlePanel = new Panel();
        this.statusPanel = new Panel();
        Panel panel2 = new Panel();
        this.colorbarPanel = new AnimationColorBarPanel();
        this.displayPanel = new AnimationDisplayPanel(this);
        this.bPlusOne = new Button(">>");
        this.bMinusOne = new Button("<<");
        this.bAuto = new Button("Auto");
        this.bPlusOne.addActionListener(this);
        this.bMinusOne.addActionListener(this);
        this.bAuto.addActionListener(this);
        this.redrawDelay = 500;
        this.lDelay = new Label("Frame Refresh Delay:", 1);
        this.delayField = new TimeTextField("500 ms", 8);
        this.delayField.addActionListener(this);
        this.setRanges = new Button("Set Ranges");
        this.setRanges.addActionListener(this);
        this.titlePanel.setBackground(Analysis.background);
        this.titlePanel.setForeground(Analysis.foreground);
        Font font = new Font("SansSerif", 1, 16);
        this.lTitle = new Label("", 1);
        this.lTitle.setFont(font);
        this.setTitleInfo(0);
        this.titlePanel.add(this.lTitle);
        this.lStatus = new Label("");
        this.statusPanel.add((Component)this.lStatus, "Center");
        this.statusPanel.setBackground(Color.lightGray);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        panel2.setLayout(gridBagLayout);
        Util.gblAdd(panel2, this.bMinusOne, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(panel2, this.bPlusOne, gridBagConstraints, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(panel2, this.bAuto, gridBagConstraints, 2, 0, 1, 1, 1, 1);
        Util.gblAdd(panel2, this.lDelay, gridBagConstraints, 3, 0, 1, 1, 1, 1);
        Util.gblAdd(panel2, this.delayField, gridBagConstraints, 4, 0, 1, 1, 1, 1);
        Util.gblAdd(panel2, this.setRanges, gridBagConstraints, 5, 0, 1, 1, 1, 1);
        panel.setBackground(Color.gray);
        panel.setLayout(gridBagLayout);
        Util.gblAdd(panel, this.titlePanel, gridBagConstraints, 0, 0, 1, 1, 1, 0);
        Util.gblAdd(panel, this.displayPanel, gridBagConstraints, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(panel, this.colorbarPanel, gridBagConstraints, 0, 2, 1, 1, 1, 0);
        Util.gblAdd(panel, this.statusPanel, gridBagConstraints, 0, 3, 1, 1, 1, 0);
        Util.gblAdd(panel, panel2, gridBagConstraints, 0, 4, 1, 1, 1, 0);
        this.getContentPane().add((Component)panel, "Center");
        this.layoutComplete = true;
    }

    private void createMenus() {
    }

    public void setStatusInfo(int n, int n2, int n3) {
        String string = n < 0 ? "" : "Processor " + n + ": Usage = " + n3 + "% at " + U.t(this.startTime + (long)n2 * this.intervalSize);
        this.lStatus.setText(string);
        this.lStatus.invalidate();
        this.statusPanel.validate();
    }

    public void setTitleInfo(int n) {
        String string = "Processor Usage at " + U.t(this.startTime + (long)n * this.intervalSize) + "(" + U.t(this.intervalSize) + " step)";
        this.lTitle.setText(string);
        this.lTitle.invalidate();
        this.titlePanel.validate();
    }

    class AnimateThread
    extends Thread {
        public AnimateThread() {
            AnimationWindow.this.keepAnimating = true;
        }

        public void run() {
            long l = (long)AnimationWindow.this.redrawDelay + System.currentTimeMillis();
            while (AnimationWindow.this.keepAnimating) {
                long l2 = l - System.currentTimeMillis();
                if (l2 > 0L) {
                    try {
                        Thread.sleep(l2);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                l += (long)AnimationWindow.this.redrawDelay;
                AnimationWindow.this.changeCurI(AnimationWindow.this.displayPanel.getCurI() + 1);
            }
        }
    }
}

