/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import javax.swing.JPanel;

public class BackGroundImagePanel
extends JPanel {
    private Image bgimage = null;
    private boolean tile;

    public BackGroundImagePanel(Image image, boolean bl) {
        this.bgimage = image;
        this.tile = bl;
    }

    public BackGroundImagePanel(Image image) {
        this(image, true);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.bgimage != null) {
            this.wallPaper(this, graphics, this.bgimage);
        }
    }

    private void wallPaper(Component component, Graphics graphics, Image image) {
        Dimension dimension = component.getSize();
        this.waitForImage(component, image);
        int n = image.getWidth(component);
        int n2 = image.getHeight(component);
        if (this.tile) {
            int n3 = 0;
            while (n3 < dimension.width) {
                int n4 = 0;
                while (n4 < dimension.height) {
                    graphics.drawImage(image, n3, n4, component);
                    n4 += n2;
                }
                n3 += n;
            }
        } else {
            this.setPreferredSize(new Dimension(n, n2));
            graphics.drawImage(image, 0, 0, component);
        }
    }

    private void waitForImage(Component component, Image image) {
        MediaTracker mediaTracker = new MediaTracker(component);
        try {
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

