/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.graph;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import projections.gui.Analysis;
import projections.gui.JFloatTextField;
import projections.gui.Util;
import projections.gui.graph.DataSource1D;
import projections.gui.graph.Graph;
import projections.gui.graph.XAxisFixed;
import projections.gui.graph.YAxisAuto;

public class GraphPanel
extends JPanel
implements ActionListener,
ItemListener {
    private JPanel mainPanel;
    private JScrollPane displayPanel;
    private Graph displayCanvas;
    private JRadioButton cbLineGraph;
    private JRadioButton cbBarGraph;
    private JRadioButton cbAreaGraph;
    private JCheckBox cbStacked;
    private JButton bIncreaseX;
    private JButton bDecreaseX;
    private JButton bResetX;
    private JLabel lScaleX;
    private JFloatTextField scaleFieldX;
    private JButton bIncreaseY;
    private JButton bDecreaseY;
    private JButton bResetY;
    private JLabel lScaleY;
    private JFloatTextField scaleFieldY;

    public GraphPanel(Graph graph) {
        this.setBackground(Color.lightGray);
        this.displayCanvas = graph;
        this.createLayout();
    }

    private void createLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "graph type"));
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        ButtonGroup buttonGroup = new ButtonGroup();
        this.cbLineGraph = new JRadioButton("Line Graph");
        this.cbLineGraph.setActionCommand("line");
        this.cbBarGraph = new JRadioButton("Bar Graph", true);
        this.cbBarGraph.setActionCommand("bar");
        this.cbAreaGraph = new JRadioButton("Area Graph");
        this.cbAreaGraph.setActionCommand("area");
        this.cbStacked = new JCheckBox("Stacked");
        this.cbStacked.setSelected(true);
        buttonGroup.add(this.cbLineGraph);
        buttonGroup.add(this.cbBarGraph);
        buttonGroup.add(this.cbAreaGraph);
        this.cbLineGraph.addActionListener(this);
        this.cbBarGraph.addActionListener(this);
        this.cbAreaGraph.addActionListener(this);
        this.cbStacked.addItemListener(this);
        Util.gblAdd(jPanel, this.cbLineGraph, gridBagConstraints, 0, 0, 1, 1, 1, 0);
        Util.gblAdd(jPanel, this.cbBarGraph, gridBagConstraints, 1, 0, 1, 1, 1, 0);
        Util.gblAdd(jPanel, this.cbAreaGraph, gridBagConstraints, 2, 0, 1, 1, 1, 0);
        Util.gblAdd(jPanel, this.cbStacked, gridBagConstraints, 3, 0, 1, 1, 1, 0);
        if (this.displayCanvas.getGraphType() == 5) {
            this.cbLineGraph.setSelected(true);
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "x-scale"));
        this.lScaleX = new JLabel("X-Axis Scale: ", 0);
        this.scaleFieldX = new JFloatTextField(1.0f, 5);
        this.scaleFieldX.addActionListener(this);
        this.bDecreaseX = new JButton("<<");
        this.bIncreaseX = new JButton(">>");
        this.bResetX = new JButton("Reset");
        this.bIncreaseX.addActionListener(this);
        this.bDecreaseX.addActionListener(this);
        this.bResetX.addActionListener(this);
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        Util.gblAdd(jPanel2, this.bDecreaseX, gridBagConstraints, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(jPanel2, this.lScaleX, gridBagConstraints, 1, 0, 1, 1, 0, 0);
        Util.gblAdd(jPanel2, this.scaleFieldX, gridBagConstraints, 2, 0, 1, 1, 1, 0);
        Util.gblAdd(jPanel2, this.bIncreaseX, gridBagConstraints, 3, 0, 1, 1, 0, 0);
        Util.gblAdd(jPanel2, this.bResetX, gridBagConstraints, 4, 0, 1, 1, 0, 0);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "y-scale"));
        this.lScaleY = new JLabel("Y-Axis Scale: ", 0);
        this.scaleFieldY = new JFloatTextField(1.0f, 5);
        this.scaleFieldY.addActionListener(this);
        this.bDecreaseY = new JButton("<<");
        this.bIncreaseY = new JButton(">>");
        this.bResetY = new JButton("Reset");
        this.bIncreaseY.addActionListener(this);
        this.bDecreaseY.addActionListener(this);
        this.bResetY.addActionListener(this);
        jPanel3.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        Util.gblAdd(jPanel3, this.bDecreaseY, gridBagConstraints, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(jPanel3, this.lScaleY, gridBagConstraints, 1, 0, 1, 1, 0, 0);
        Util.gblAdd(jPanel3, this.scaleFieldY, gridBagConstraints, 2, 0, 1, 1, 1, 0);
        Util.gblAdd(jPanel3, this.bIncreaseY, gridBagConstraints, 3, 0, 1, 1, 0, 0);
        Util.gblAdd(jPanel3, this.bResetY, gridBagConstraints, 4, 0, 1, 1, 0, 0);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        Util.gblAdd(jPanel4, jPanel, gridBagConstraints, 0, 0, 2, 1, 1, 0);
        Util.gblAdd(jPanel4, jPanel2, gridBagConstraints, 0, 1, 1, 1, 1, 0);
        Util.gblAdd(jPanel4, jPanel3, gridBagConstraints, 1, 1, 1, 1, 1, 0);
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(gridBagLayout);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        this.displayPanel = new JScrollPane(this.displayCanvas);
        jPanel5.add(this.displayPanel);
        Util.gblAdd(this.mainPanel, jPanel5, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this, this.mainPanel, gridBagConstraints, 0, 0, 1, 1, 1, 1, 5, 5, 5, 5);
        Util.gblAdd(this, jPanel4, gridBagConstraints, 0, 1, 1, 1, 1, 0, 2, 2, 2, 2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        float f = this.scaleFieldX.getValue();
        float f2 = this.scaleFieldY.getValue();
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.bDecreaseX) {
                f3 = (float)((int)(f * 4.0f) - 1) / 4.0f;
                if ((double)f3 < 1.0) {
                    f3 = 1.0f;
                }
            } else if (jButton == this.bIncreaseX) {
                f3 = (float)((int)(f * 4.0f) + 1) / 4.0f;
            } else if (jButton == this.bResetX) {
                f3 = 1.0f;
            } else if (jButton == this.bDecreaseY) {
                f4 = (float)((int)(f2 * 4.0f) - 1) / 4.0f;
                if ((double)f4 < 1.0) {
                    f4 = 1.0f;
                }
            } else if (jButton == this.bIncreaseY) {
                f4 = (float)((int)(f2 * 4.0f) + 1) / 4.0f;
            } else if (jButton == this.bResetY) {
                f4 = 1.0f;
            }
            if (f3 != f && (double)f3 > 0.0) {
                this.scaleFieldX.setText("" + f3);
                this.displayCanvas.setScaleX(f3);
            }
            if (f4 != f2 && (double)f4 > 0.0) {
                this.scaleFieldY.setText("" + f4);
                this.displayCanvas.setScaleY(f4);
            }
        } else if (actionEvent.getSource() instanceof JFloatTextField) {
            JFloatTextField jFloatTextField = (JFloatTextField)actionEvent.getSource();
            if (jFloatTextField == this.scaleFieldX) {
                f3 = f;
                this.displayCanvas.setScaleX(f3);
            } else if (jFloatTextField == this.scaleFieldY) {
                f4 = f2;
                this.displayCanvas.setScaleY(f4);
            }
        } else if (actionEvent.getSource() instanceof JRadioButton) {
            if (actionEvent.getActionCommand().equals("line")) {
                this.displayCanvas.setGraphType(5);
                this.cbStacked.setEnabled(true);
            } else if (actionEvent.getActionCommand().equals("bar")) {
                this.displayCanvas.setGraphType(4);
                this.cbStacked.setEnabled(true);
            } else if (actionEvent.getActionCommand().equals("area")) {
                this.cbStacked.setSelected(true);
                this.displayCanvas.setStackGraph(true);
                this.displayCanvas.setGraphType(2);
                this.cbStacked.setEnabled(false);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.cbStacked) {
            if (itemEvent.getStateChange() == 1) {
                this.displayCanvas.setStackGraph(true);
            } else {
                this.displayCanvas.setStackGraph(false);
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        int[] nArray = new int[]{6, 554, 612, 571, 1354, 819, 385, 151, 76, 54, 34, 11, 2};
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        DataSource1D dataSource1D = new DataSource1D("Histogram", nArray);
        XAxisFixed xAxisFixed = new XAxisFixed("Grainsize", "ms");
        xAxisFixed.setLimits(1.0, 2.0);
        YAxisAuto yAxisAuto = new YAxisAuto("Number of Computes", "", dataSource1D);
        Analysis.foreground = Color.black;
        Analysis.background = Color.white;
        Graph graph = new Graph();
        graph.setGraphType(4);
        graph.setStackGraph(true);
        graph.setData(dataSource1D, xAxisFixed, yAxisAuto);
        GraphPanel graphPanel = new GraphPanel(graph);
        JMenuBar jMenuBar = new JMenuBar();
        jFrame.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Trial Item");
        jMenu.add(jMenuItem);
        jFrame.getContentPane().add(graphPanel);
        jFrame.pack();
        jFrame.setTitle("Projections");
        jFrame.setVisible(true);
    }
}

