/***************************************************
 * An example demostrating the use of fftlib	
 * Need to compile fftlib first. 
 *  (Goto charm/tmp/libs/ck-libs/fftlib, do 'make')
 ***************************************************/
#include <charm++.h>
#include <fftlib.h>
#include "app.h"
#include "app.decl.h"

CProxy_SrcArray srcArray;
CProxy_DestArray destArray;

main::main(CkArgMsg *m)
{
	int y;
	int dim=16;

	int srcDim[2] = {dim, dim};
	int destDim[2] = {dim, dim};

	srcArray = CProxy_SrcArray::ckNew();
	destArray = CProxy_DestArray::ckNew();
	NormalFFTinfo src_info(srcArray, destArray, srcDim, destDim, true, NULL, 4, 2), dest_info(srcArray, destArray, srcDim, destDim, false, NULL, 4, 2);
	for (y = 0; y < dim; y+=2) {
		destArray(y).insert(dest_info);
		if (y % 4 != 0)
			continue;
		srcArray(y).insert(src_info);
	}
	
	destArray.doneInserting();
	srcArray.doneInserting();
	srcArray.doIt(0);
	srcArray.doIt(1);
}

#include "app.def.h"
