#include "pgm.h"

CkChareID mainhandle;

void 
UserArray::doSendRecv(void)
{
  int i;
  double *buff;
  buff = (double *) malloc(256*sizeof(double));
  for(i=0;i<256;i++)
    buff[i] = (double)i;
  if(thisIndex) {
    for(i=0;i<NITER;i++) {
      ckTempoRecv(i, (void *)buff, 256*sizeof(double));
      ckTempoSendElem(i, (void *)buff, 256*sizeof(double),0);
    }
  } else {
    for(i=0;i<NITER;i++) {
      ckTempoSendElem(i, (void *)buff, 256*sizeof(double),1);
      ckTempoRecv(i, (void *)buff, 256*sizeof(double));
    }
    CProxy_main pm(mainhandle);
    pm.Finish();
  }
}

main::main(CkArgMsg *)
{
  CkArrayID aid = CProxy_UserArray::ckNew(2);
  CProxy_UserArray pua(aid);
  pua[0].doSendRecv();
  pua[1].doSendRecv();
  mainhandle = thishandle;
  starttime = CkTimer();
}

void 
main::Finish(void)
{
  endtime = CkTimer();
  CkPrintf("RTT = %lf microseconds\n", (endtime-starttime)*1.e6/NITER);
  CkExit();
}

#include "pgm.def.h"
