#ifndef _JACOBI_H
#define _JACOBI_H

#include "jacobi.decl.h"
#include "main.h"

#define NBLOCKS 5
#define HEIGHT 100
#define WIDTH  10

class MigrateInfo : public CMessage_MigrateInfo {
  public:
    ArrayElement *elem;
    int where;
    MigrateInfo(ArrayElement *e, int w) : elem(e), where(w) {}
};

class jacobi : public TempoArray {
  public:
    jacobi(ArrayElementCreateMessage *msg);
    jacobi(ArrayElementMigrateMessage *msg);
    int packsize(void);
    void pack(void *buf);
    void run(void);
    static int numBlocks(void) { return NBLOCKS; }
};

extern int migHandle;

class migrator : public Group {
  public:
    migrator(void) { migHandle = thisgroup; }
    void migrateElement(MigrateInfo *msg) {
      msg->elem->migrate(msg->where);
      delete msg;
    }
};
#endif
